import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'lotRuleId',
    label: '单件/批次号规则',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/jcxx/getLot',
        method: 'GET',
        apiId: 'c2c9e271bd684ba3bf4e57ff94f82e54',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_lot_rule where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'internalCode',
    label: '内部标识',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'deductionBasis',
    label: '扣料依据',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '产品MOD', value: '产品MOD' },
        { key: 2, label: '工艺MOD', value: '工艺MO' },
      ],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'lotRuleId',
    title: '单件/批次号规则',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'deductionBasis',
    title: '扣料依据',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '产品MOD', value: '产品MOD' },
        { key: 2, label: '工艺MOD', value: '工艺MO' },
      ];

      return staticOptions.filter((x) => x.value == record.deductionBasis)[0]?.label;
    },

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '1a2696deffa44bc08208686bb5e77715',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '8d9ef135306242729fb4673b9e2dd918',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '097aabe7380a49f5a691ed3b0613ab26',
              field: 'lotRuleId',
              label: '单件/批次号规则',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 16,
                placeholder: '请选择下拉选择单件/批次号规则',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getLot',
                  method: 'GET',
                  apiId: 'c2c9e271bd684ba3bf4e57ff94f82e54',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_lot_rule where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '8a507b277c4d46fb9c3dacc18f98a41b',
              field: 'internalCode',
              label: '内部标识',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 11,
                defaultValue: '',
                placeholder: '请输入内部标识',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6636f959cd3a4c239aeb3ab43505a27b',
              field: 'active',
              label: '有效的',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 7,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#433653',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'e64fff4326284f16aa6d86acb8678b89',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '4646ad154e7d404e9dae94f1022a5788',
              field: '',
              label: '',
              type: 'tab',
              colProps: { span: 24 },
              component: 'Tab',
              children: [
                {
                  span: 24,
                  name: '工艺明细',
                  prefix: '',
                  suffix: '',
                  activeColor: '#1c8dff',
                  folderId: '',
                  imageUrl: '',
                  conFolderId: '',
                  conImageUrl: '',
                  list: [
                    {
                      key: '3c2b6278f4114cbc86780eec1f980f0c',
                      label: '',
                      field: 'rokeRoutingLineList',
                      type: 'form',
                      component: 'SubForm',
                      required: true,
                      colProps: { span: 24 },
                      componentProps: {
                        mainKey: 'rokeRoutingLineList',
                        columns: [
                          {
                            key: '9432fa26a1e44a25b1d68d28eed7372a',
                            title: '工序',
                            dataIndex: 'processId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择工序',
                              showLabel: true,
                              showSearch: true,
                              isMultiple: false,
                              clearable: false,
                              disabled: false,
                              staticOptions: [
                                { key: 1, label: '毛胚原料', value: '毛胚原料' },
                                { key: 2, label: '车床', value: '车床' },
                              ],
                              defaultSelect: '',
                              datasourceType: 'api',
                              params: null,
                              labelField: 'label',
                              valueField: 'value',
                              apiConfig: {
                                path: '/jcxx/getProcessList',
                                method: 'GET',
                                apiId: 'copy1766022481900d48902',
                                apiParams: [
                                  {
                                    key: '1',
                                    title: 'Query Params',
                                    tableInfo: [
                                      {
                                        name: 'processType',
                                        value: '1',
                                        description: null,
                                        required: true,
                                        dataType: null,
                                        type: null,
                                        defaultValue: null,
                                        validateType: null,
                                        error: null,
                                        expression: null,
                                        children: null,
                                        bindType: 'value',
                                      },
                                    ],
                                  },
                                  { key: '2', title: 'Header', tableInfo: [] },
                                  { key: '3', title: 'Body' },
                                ],
                                script:
                                  'var sql="select id as value,name as label from roke_process where process_type = #{processType} and delete_mark = 0";\r\nreturn db.select(sql);',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {
                                change:
                                  "// 取第一行，统一引用，避免多处硬编码 [0]\nconst row = formModel.roke_routing_lineList?.[0];\n\nif (!row || !row.process_id) {\n  console.warn('工序行或 process_id 不存在', row);\n  return;\n}\n\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/jcxx/getProcess',\n  params: {\n    id: row.process_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n\n  // 兼容 magic-api 常见返回结构\n  const list = res?.data || res;\n\n  if (Array.isArray(list) && list.length > 0) {\n    row.rated_working_hours = list[0].rated_working_hours;\n  } else {\n    formActionType.showMessage('未查询到工序信息');\n  }\n\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formActionType.showMessage('接口请求异常');\n});\n",
                              },
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: 'c8785464a8a24157abeb102aa6637d0e',
                            title: '工序提前/预产期',
                            dataIndex: 'inAdvTime',
                            componentType: 'InputNumber',
                            defaultValue: 1,
                            componentProps: {
                              width: '100%',
                              span: 6,
                              defaultValue: 1,
                              min: 0,
                              max: 100,
                              step: 0.01,
                              maxlength: null,
                              disabled: false,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: 'dbafb88382df488696722e143ff1b9b3',
                            title: '计薪规则',
                            dataIndex: 'salaryRule',
                            componentType: 'Input',
                            defaultValue: '每 1.0 产品单位 0.0 元',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '每 1.0 产品单位 0.0 元',
                              placeholder: '请输入计薪规则计薪规则',
                              maxlength: null,
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: false,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '63b9efd0597a4b73b381e31b2b0ec874',
                            title: '工序报工数',
                            dataIndex: 'workQty',
                            componentType: 'InputNumber',
                            defaultValue: 1,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 1,
                              min: 0,
                              max: 100,
                              step: 0.01,
                              maxlength: null,
                              disabled: false,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: 'd7a9c539183d43a29ff1689e2cbe87e2',
                            title: '最终成品数',
                            dataIndex: 'finishedQty',
                            componentType: 'InputNumber',
                            defaultValue: 1,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 1,
                              min: 0,
                              max: 100,
                              step: 0.01,
                              maxlength: null,
                              disabled: false,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: 'e20b853140d143e7a90cf447ce0df137',
                            title: '消耗工序',
                            dataIndex: 'consumeProcessId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择',
                              showLabel: true,
                              showSearch: true,
                              isMultiple: false,
                              clearable: false,
                              disabled: false,
                              staticOptions: [
                                { key: 1, label: '毛胚原料', value: '毛胚原料' },
                                { key: 2, label: '车床', value: '车床' },
                              ],
                              defaultSelect: '1',
                              datasourceType: 'api',
                              params: null,
                              labelField: 'label',
                              valueField: 'value',
                              apiConfig: {
                                path: '/jcxx/getProcessList',
                                method: 'GET',
                                apiId: 'copy1766022481900d48902',
                                apiParams: [
                                  {
                                    key: '1',
                                    title: 'Query Params',
                                    tableInfo: [
                                      {
                                        name: 'processType',
                                        value: '1',
                                        description: null,
                                        required: true,
                                        dataType: null,
                                        type: null,
                                        defaultValue: null,
                                        validateType: null,
                                        error: null,
                                        expression: null,
                                        children: null,
                                        bindType: 'value',
                                      },
                                    ],
                                  },
                                  { key: '2', title: 'Header', tableInfo: [] },
                                  { key: '3', title: 'Body' },
                                ],
                                script:
                                  'var sql="select id as value,name as label from roke_process where process_type = #{processType} and delete_mark = 0";\r\nreturn db.select(sql);',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: '6dad49cc96da4279a8eca463be7ee3b3',
                            title: '额定工时',
                            dataIndex: 'ratedWorkingHours',
                            componentType: 'InputNumber',
                            defaultValue: 1,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 1,
                              min: 0,
                              max: 100,
                              step: 0.01,
                              maxlength: null,
                              disabled: false,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: '7133da67da6f450a921a6aaa37d05364',
                            title: '采集方案',
                            dataIndex: 'collectionSchemeId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择',
                              showLabel: true,
                              showSearch: true,
                              isMultiple: false,
                              clearable: false,
                              disabled: false,
                              staticOptions: [{ key: 1, label: '无', value: '无' }],
                              defaultSelect: '',
                              datasourceType: 'staticData',
                              params: null,
                              labelField: 'label',
                              valueField: 'value',
                              apiConfig: {
                                path: 'CodeGeneration/selection',
                                method: 'GET',
                                apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: 'd806a68e571c47ecbc653755cd908b0b',
                            title: '采集项',
                            dataIndex: 'collectionItemId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择',
                              showLabel: true,
                              showSearch: true,
                              isMultiple: true,
                              clearable: false,
                              disabled: false,
                              staticOptions: [{ key: 1, label: '环境温度', value: '环境温度' }],
                              defaultSelect: null,
                              datasourceType: 'dic',
                              params: { itemId: '2001194974510096385' },
                              labelField: 'name',
                              valueField: 'value',
                              apiConfig: {
                                path: 'CodeGeneration/selection',
                                method: 'GET',
                                apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              itemId: '2001194974510096385',
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: 'df36ce1665194f998c7f7b43bdf3e730',
                            title: '作业规范',
                            dataIndex: 'standardItemsNumber',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              max: 100,
                              step: 1,
                              maxlength: null,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: 'cce7f159869e44d7b7243b7f0b9544ed',
                            title: '作业指导',
                            dataIndex: 'documentNumber',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              max: 100,
                              step: 1,
                              maxlength: null,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: '569b4f85f2a243d4bf69d190a7d299ba',
                            title: '关键物料',
                            dataIndex: 'pBomNumber',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              max: 100,
                              step: 1,
                              maxlength: null,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: '8be06556e4864b0eb89a97477f9f8644',
                            title: '子工序',
                            dataIndex: 'childProcessNumber',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              max: 100,
                              step: 1,
                              maxlength: null,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          {
                            key: '23a0c5a0303840fd81f65f6fa36d3526',
                            title: '工作中心',
                            dataIndex: 'workCenterNumber',
                            componentType: 'InputNumber',
                            defaultValue: 0,
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: 0,
                              min: 0,
                              max: 100,
                              step: 1,
                              maxlength: null,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                        ],
                        span: '24',
                        preloadType: 'api',
                        apiConfig: {},
                        itemId: '',
                        dicOptions: [],
                        useSelectButton: false,
                        buttonName: '选择数据',
                        showLabel: true,
                        showComponentBorder: true,
                        showBorder: false,
                        bordercolor: '#f0f0f0',
                        bordershowtype: [true, true, true, true],
                        borderwidth: 1,
                        showIndex: false,
                        isShow: true,
                        multipleHeads: [],
                        buttonList: [],
                        topButtonList: [],
                        isExport: false,
                        isImport: false,
                        isDeleteSelected: false,
                        isListView: false,
                        viewList: [],
                        isShowAdd: true,
                        isShowDelete: true,
                        hasCheckedCol: false,
                        events: {},
                        showPagenation: true,
                      },
                    },
                  ],
                },
                {
                  span: 24,
                  name: '质检设置',
                  prefix: '',
                  suffix: '',
                  activeColor: '#1c8dff',
                  folderId: '',
                  imageUrl: '',
                  conFolderId: '',
                  conImageUrl: '',
                  list: [
                    {
                      key: '2b6470174fb74ea1b7ebcf0a745cc90a',
                      field: 'routingQualityMode',
                      label: '质检方式',
                      type: 'select',
                      component: 'XjrSelect',
                      colProps: { span: 24 },
                      componentProps: {
                        width: '20%',
                        span: 12,
                        placeholder: '请选择下拉选择质检方式质检方式',
                        showLabel: true,
                        showSearch: false,
                        isMultiple: false,
                        clearable: false,
                        disabled: false,
                        staticOptions: [
                          { key: 1, label: '工单质检', value: '工单质检' },
                          { key: 3, label: '质检单', value: '质检单' },
                        ],
                        defaultSelect: '',
                        datasourceType: 'staticData',
                        params: null,
                        labelField: 'label',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: true,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '20%' },
                      },
                    },
                  ],
                },
                {
                  span: 24,
                  name: '自动扣料',
                  prefix: '',
                  suffix: '',
                  activeColor: '#1c8dff',
                  folderId: '',
                  imageUrl: '',
                  conFolderId: '',
                  conImageUrl: '',
                  list: [
                    {
                      key: '810345b81a7540a4917ef3c8ab8dea1a',
                      field: '',
                      label: '',
                      type: 'grid',
                      colProps: { span: 24 },
                      component: 'Grid',
                      children: [
                        {
                          span: 6,
                          list: [
                            {
                              key: '7d2104a70396450485eb4225debf924f',
                              field: 'autoDeduction',
                              label: '自动扣料',
                              type: 'switch',
                              component: 'Switch',
                              colProps: { span: 24 },
                              defaultValue: 0,
                              componentProps: {
                                span: 17,
                                defaultValue: 0,
                                checkedChildren: '',
                                unCheckedChildren: '',
                                checkedColor: '#1C8DFF',
                                unCheckedColor: '#bbbdbf',
                                showLabel: true,
                                disabled: false,
                                events: {
                                  change:
                                    "let value = formModel.auto_deduction;\nvar fieldConfigs = [\n    {field: 'deduction_work_center'},\n    {field: 'deduction_auto_confirm'},\n    {field: 'deduction_moment'},\n    {field: 'deduction_basis'}\n];\nfieldConfigs.forEach(function(config) {\n    var isDisabled = false;\n    var isRequired = false;\n    if (value == 1) {\n        isDisabled = false;        \n        if (config.field === 'deduction_moment' || config.field === 'deduction_basis') {\n            isRequired = true;\n        }\n    } else {\n        isDisabled = true;\n        isRequired = false;\n    }\n    formActionType.updateSchema({\n        field: config.field,\n        componentProps: {\n            disabled: isDisabled,\n            required: isRequired\n        }\n    });\n});",
                                },
                                isShow: true,
                                tooltipConfig: { visible: false, title: '提示文本' },
                                style: {},
                              },
                            },
                            {
                              key: 'fdc20894032645628350fa8df3a515f3',
                              field: 'deductionWorkCenter',
                              label: '分车间扣料',
                              type: 'switch',
                              component: 'Switch',
                              colProps: { span: 24 },
                              defaultValue: 0,
                              componentProps: {
                                span: 11,
                                defaultValue: 0,
                                checkedChildren: '',
                                unCheckedChildren: '',
                                checkedColor: '#1C8DFF',
                                unCheckedColor: '#bbbdbf',
                                showLabel: true,
                                disabled: true,
                                events: {},
                                isShow: true,
                                tooltipConfig: { visible: false, title: '提示文本' },
                                style: {},
                              },
                            },
                          ],
                        },
                        {
                          span: 6,
                          list: [
                            {
                              key: '82efccd1f14a4a43b60f35ad75939c03',
                              field: 'deductionAutoConfirm',
                              label: '自动确认扣料',
                              type: 'switch',
                              component: 'Switch',
                              colProps: { span: 24 },
                              defaultValue: 0,
                              componentProps: {
                                span: 19,
                                defaultValue: 0,
                                checkedChildren: '',
                                unCheckedChildren: '',
                                checkedColor: '#1C8DFF',
                                unCheckedColor: '#bbbdbf',
                                showLabel: true,
                                disabled: true,
                                events: {},
                                isShow: true,
                                tooltipConfig: { visible: false, title: '提示文本' },
                                style: {},
                              },
                            },
                          ],
                        },
                        {
                          span: 6,
                          list: [
                            {
                              key: '1684c8eba06c45c1a0e4df9bcbe4eaf2',
                              field: 'deductionMoment',
                              label: '  扣料节点',
                              type: 'select',
                              component: 'XjrSelect',
                              colProps: { span: 24 },
                              componentProps: {
                                width: '100%',
                                span: 17,
                                placeholder: '请选择下拉选择',
                                showLabel: true,
                                showSearch: false,
                                isMultiple: false,
                                clearable: false,
                                disabled: true,
                                staticOptions: [
                                  { key: 1, label: '首道扣料', value: '首道扣料' },
                                  { key: 2, label: '末道扣料', value: '末道扣料' },
                                  { key: 3, label: '入库扣料', value: '入库扣料' },
                                  { key: 4, label: '分步扣料', value: '分步扣料' },
                                ],
                                defaultSelect: '',
                                datasourceType: 'staticData',
                                params: null,
                                labelField: 'label',
                                valueField: 'value',
                                apiConfig: {
                                  path: 'CodeGeneration/selection',
                                  method: 'GET',
                                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                                },
                                dicOptions: [],
                                required: false,
                                rules: [],
                                events: {},
                                isShow: true,
                                tooltipConfig: { visible: false, title: '提示文本' },
                                style: { width: '100%' },
                              },
                            },
                          ],
                        },
                        {
                          span: 6,
                          list: [
                            {
                              key: 'f529e8bc463f4811983593cf2987e15e',
                              field: 'deductionBasis',
                              label: '扣料依据',
                              type: 'select',
                              component: 'XjrSelect',
                              colProps: { span: 24 },
                              componentProps: {
                                width: '100%',
                                span: 17,
                                placeholder: '请选择下拉选择',
                                showLabel: true,
                                showSearch: false,
                                isMultiple: false,
                                clearable: false,
                                disabled: true,
                                staticOptions: [
                                  { key: 1, label: '产品MOD', value: '产品MOD' },
                                  { key: 2, label: '工艺MOD', value: '工艺MO' },
                                ],
                                defaultSelect: '',
                                datasourceType: 'staticData',
                                params: null,
                                labelField: 'label',
                                valueField: 'value',
                                apiConfig: {
                                  path: 'CodeGeneration/selection',
                                  method: 'GET',
                                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                                },
                                dicOptions: [],
                                required: false,
                                rules: [],
                                events: {},
                                isShow: true,
                                tooltipConfig: { visible: false, title: '提示文本' },
                                style: { width: '100%' },
                              },
                            },
                          ],
                        },
                      ],
                      componentProps: {
                        gutter: 16,
                        justify: 'start',
                        align: 'top',
                        isShow: true,
                        showBorder: false,
                        bordercolor: '#d9d9d9',
                        bordershowtype: [true, true, true, true],
                        borderwidth: 1,
                        padding: '10px',
                        margin: '10px',
                      },
                    },
                  ],
                },
              ],
              componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
            },
            {
              key: '16cce9dceb104efc9af33d84f3734488',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
