import { MesProOrderworkReportworkModel, MesProOrderworkReportworkPageParams, MesProOrderworkReportworkPageResult } from './model/ProworkreportModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proworkreport/page',
  List = '/mes/proworkreport/list',
  Info = '/mes/proworkreport/info',
  MesProOrderworkReportwork = '/mes/proworkreport',
  
  
}

/**
 * @description: 查询MesProOrderworkReportwork分页列表
 */
export async function getMesProOrderworkReportworkPage(params: MesProOrderworkReportworkPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderworkReportworkPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrderworkReportwork信息
 */
export async function getMesProOrderworkReportwork(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderworkReportworkModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrderworkReportwork
 */
export async function addMesProOrderworkReportwork(mesProOrderworkReportwork: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrderworkReportwork,
      params: mesProOrderworkReportwork,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrderworkReportwork
 */
export async function updateMesProOrderworkReportwork(mesProOrderworkReportwork: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrderworkReportwork,
      params: mesProOrderworkReportwork,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrderworkReportwork（批量删除）
 */
export async function deleteMesProOrderworkReportwork(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrderworkReportwork,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}