import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQpProcessFirst分页参数 模型
 */
export interface MesQpProcessFirstPageParams extends BasicPageParams {
  reportNo: string;

  checkDate: string;

  checkUser: string;

  reportName: string;

  saleNo: string;

  productCode: string;

  productName: string;

  materialNo: string;

  materialName: string;

  errorState: string;

  checkreportNo: string;

  judgeResult: string;

  remark: string;
}

/**
 * @description: MesQpProcessFirst分页返回值模型
 */
export interface MesQpProcessFirstPageModel {
  id: string;

  reportNo: string;

  checkDate: string;

  checkUser: string;

  reportName: string;

  saleNo: string;

  productCode: string;

  productName: string;

  materialNo: string;

  materialName: string;

  judgeResult: string;

  createDate: string;

  errorState: string;
}

/**
 * @description: MesQpProcessFirst表类型
 */
export interface MesQpProcessFirstModel {
  id: number;

  isSysNum: string;

  reportNo: string;

  reportName: string;

  checkUser: string;

  checkDate: string;

  saleId: string;

  saleNo: string;

  saleName: string;

  productId: string;

  productCode: string;

  productName: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  judgeResult: string;

  checkNo: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQpProcessFirstdataList?: MesQpProcessFirstdataModel;
}

/**
 * @description: MesQpProcessFirstdata表类型
 */
export interface MesQpProcessFirstdataModel {
  id: number;

  firstId: number;

  checkType: string;

  checkProduct: string;

  checkStandard: string;

  supplierName: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  judgeResult: string;

  imgFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQpProcessFirst分页返回值结构
 */
export type MesQpProcessFirstPageResult = BasicFetchResult<MesQpProcessFirstPageModel>;
