import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface SupplierPageListParams {
  state: number; //供应商类型 0-潜在 1-正式 2-淘汰
  name?: string; //供应商名称
  finalState?: string; //风险评估
  type?: string; //供应商类型
  startTime?: string; //添加开始时间
  endTime?: string; //添加结束时间
}

export interface SupplierAddParamsModel {
  number: string; //供应商编码
  name: string; //供应商名称
  isSysNumBoolean: number; //是否使用系统供应商
  scope: string; //经营范围
  person: string; //负责人
  phone: string; //手机号
  type: string; //供应商类别
}

export interface SupplierUpdateParamsModel {
  id: string; //详情id
  number: string; //供应商编码
  name: string; //供应商名称
  isSysNumBoolean: number; //是否使用系统供应商
  scope: string; //经营范围
  person: string; //负责人
  phone: string; //手机号
  type: string; //供应商类别
}

export interface SupplierInfoModel {
  id: string; //详情id
  number: string; //供应商编码
  name: string; //供应商名称
  isSysNumBoolean: number; //是否使用系统供应商
  scope: string; //经营范围
  person: string; //负责人
  phone: string; //手机号
  type: string; //供应商类别
  typeName: string; //供应商类型名称
  createUserName: string; //添加人
}

export interface SupplierListModel {
  id: string; //详情id
  name: string; //供应商名称
  symbol: string; //单位符号
  createUserName: string; //创建人
  createDate: string; //添加时间
  state: number; //状态 0-潜在 1-正式 2-淘汰
  number: string; //供应商编码
  phone: string; //手机号
  assessStateName: string; //风险评估
  assessState: number; //风险评估id
  scope: string; //经营范围
  type: string; //供应商类型
  typeName: string; //供应商类型名称
}

export interface RiskAddParamsModel {
  capacityFilePath?: string; //供货能力附件
  capacityLevel: number; //供货能力等级
  capacityReason: string; //供货能力评估理由
  finalReason: string; //最终结果理由
  finalState: number; //最终结果等级
  qualityFilePath?: string; //供货质量附件
  qualityLevel: number; //供货质量等级
  qualityReason: string; //供货质量评估理由
  safetyFilePath?: string; //环境与安全附件
  safetyLevel: number; //环境与安全等级
  safetyReason: string; //环境与安全评估理由
  supplierId: string; //id
  type: number;
}

export interface ApplicationAddParamsModel {
  supplierId: string; //id
  reason: string; //理由
  filePath?: string; //附件
}

export type SupplierPageListSearchModel = BasicPageParams & SupplierPageListParams;
export type SupplierPageListResultModel = BasicFetchResult<SupplierListModel>;
