import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cphm',
    label: '车牌号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cllx',
    label: '车辆类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2017066632836796418' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'clmc',
    label: '车辆名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'bz',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cphm',
    title: '车牌号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cllx',
    title: '车辆类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clmc',
    title: '车辆名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bz',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '4e3e16ce2d6945a0992e29acbdfa957a',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'ed751fad10d040e1a485cca457dfdb76',
              field: 'cphm',
              label: '车牌号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入车牌号',
                maxlength: 50,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'c456168f54424a868e3d29bb5ee65f69',
              field: 'cllx',
              label: '车辆类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2017066632836796418' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2017066632836796418',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'a24abbc443e04ae595c006c0fb4deb0f',
              field: 'clmc',
              label: '车辆名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入车辆名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '8b98de2c8ee94a559e97b7a617a819b3',
      field: 'bz',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
