import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesEquipment分页参数 模型
 */
export interface MesEquipmentPageParams extends BasicPageParams {
  name: string;

  companyId: string;

  categoryId: string;

  eState: string;
}

/**
 * @description: MesEquipment分页返回值模型
 */
export interface MesEquipmentPageModel {
  id: string;

  name: string;

  specification: string;

  categoryId: string;

  eState: string;

  companyId: string;
}

/**
 * @description: MesEquipment表类型
 */
export interface MesEquipmentModel {
  id: string;

  deleteMark: string;

  messageMainAttachmentId: string;

  name: string;

  code: string;

  categoryId: string;

  active: string;

  workCenterId: string;

  lastSpotDate: string;

  location: string;

  indexCode: string;

  manufacturer: string;

  manufacturerCode: string;

  specification: string;

  manufactureDate: string;

  warrantyDate: string;

  registerCode: string;

  createArchivesUserId: string;

  archivesCode: string;

  archivesDate: string;

  usePermitCode: string;

  testOrgId: string;

  lastTestDate: string;

  nextTestDate: string;

  userId: string;

  note: string;

  inRepair: string;

  isPart: string;

  parentEqptId: string;

  eState: string;

  companyId: string;

  isHasScrapped: string;

  price: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesEquipment分页返回值结构
 */
export type MesEquipmentPageResult = BasicFetchResult<MesEquipmentPageModel>;
