
import { MesWarehouseProductNumberPageModel, MesWarehouseProductNumberPageParams, MesWarehouseProductNumberPageResult } from './model/KczbModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/kczb/page',
  List = '/ckgl/kczb/list',
  Info = '/ckgl/kczb/info',
  MesWarehouseProductNumber = '/ckgl/kczb',
  
  
  
}

/**
 * @description: 查询MesWarehouseProductNumber分页列表
 */
export async function getMesWarehouseProductNumberPage(params: MesWarehouseProductNumberPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductNumberPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseProductNumber信息
 */
export async function getMesWarehouseProductNumber(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductNumberPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseProductNumber
 */
export async function addMesWarehouseProductNumber(mesWarehouseProductNumber: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseProductNumber,
      params: mesWarehouseProductNumber,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseProductNumber
 */
export async function updateMesWarehouseProductNumber(mesWarehouseProductNumber: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseProductNumber,
      params: mesWarehouseProductNumber,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseProductNumber（批量删除）
 */
export async function deleteMesWarehouseProductNumber(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseProductNumber,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




