import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'defaultReporter',
    label: '默认报工人员',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getEmployeeList',
        method: 'GET',
        apiId: 'copy1765432049337d61208',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'categoryId',
    label: '工序类别',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2005547790246666242' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'collectionSchemeId',
    label: '采集方案',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [{ key: 1, label: '无', value: '无' }],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'categoryId',
    title: '工序类别',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'collectionSchemeId',
    title: '采集方案',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [{ key: 1, label: '无', value: '无' }];

      return staticOptions.filter((x) => x.value == record.collectionSchemeId)[0]?.label;
    },

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'ratedWorkingHours',
    title: '额定工时',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'left',
  layout: 'horizontal',
  size: 'small',
  schemas: [
    {
      key: '04fbf175bf2a4661a06e44126776617b',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '60af544637c442bcb20cdbf2cd71a2c2',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'aa72d19636d540078e40a0dae8b90e3c',
              field: 'defaultReporter',
              label: '默认报工人员',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '16def0c2f9d8422da5d403e11b8c38e0',
              field: 'categoryId',
              label: '工序类别',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2005547790246666242' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/gxlb/getTypeList',
                  method: 'GET',
                  apiId: 'c1695a5b0fbe48e1817740557a3c5d4e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_process_category";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2005547790246666242',
                style: { width: '100%' },
              },
            },
            {
              key: 'aabb539eede446daa35c754416cc50ae',
              field: 'prepareWorkHours',
              label: '是否委外',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '55d03e0607bc4ea281a248fdcfc571bb',
              field: 'collectionSchemeId',
              label: '采集方案',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '无', value: '无' }],
                defaultSelect: '无',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {},
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'ca8257a46070472e9639110b11f7f3bd',
              field: 'ratedWorkingHours',
              label: '额定工时',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: 100,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'e2c431530e954e53852f9a6026987e0d',
              field: 'active',
              label: '有效的',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 5,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '24f0714c9f3a4242b1bcefff04bb7314',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '作业规范',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: 'f7c26bba94034dcdbc816e49607d64e9',
              field: 'zyzdFile',
              label: '作业指导',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: '',
                defaultValue: '',
                accept: 'pdf,png,jpg',
                maxNumber: 10,
                maxSize: 100,
                showLabel: true,
                multiple: true,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 24,
          name: '作业指导图片',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: 'f0db1f4ee6254dd58b8f6e5f66ab7030',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: 'f40c42bc3b174f7589179a6b8976eb65',
                      field: 'zyzdtpFile',
                      label: '作业指导',
                      type: 'upload',
                      component: 'Upload',
                      colProps: { span: 24 },
                      componentProps: {
                        api: '#{upload}#',
                        span: 7,
                        defaultValue: '',
                        accept: '',
                        maxNumber: 10,
                        maxSize: 50,
                        showLabel: true,
                        multiple: false,
                        disabled: false,
                        required: false,
                        isShow: true,
                        events: {},
                        listType: 'picture',
                        sourceType: 'album,camera',
                        tooltipConfig: { visible: false, title: '提示文本' },
                      },
                    },
                  ],
                },
                { span: 12, list: [] },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
          ],
        },
        {
          span: 0,
          name: '采集项',
          prefix: null,
          suffix: null,
          activeColor: null,
          folderId: null,
          imageUrl: null,
          conFolderId: null,
          conImageUrl: null,
          list: [],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
    {
      key: '03c19c5ac95b4d139d8380ede64f14ff',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '04ae7a540acd4c46949c6fd53e652a45',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 0,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 1,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const treeConfig = {
  id: '',
  name: '',
  type: 1,
  configTip: '',
  config: [],
  isMultiple: false,
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
