import { Tag } from 'ant-design-vue';
import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { NewsCategoryDic } from '/@/enums/oa';
import { useI18n } from '/@/hooks/web/useI18n';
import { h } from 'vue';
const { t } = useI18n();
export const searchFormSchema: FormSchema[] = [
  {
    field: 'keyword',
    label: '',
    component: 'Input',
    colProps: { span: 8 },
    componentProps: {
      placeholder: t('请输入关键字'),
    },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'briefHead',
    title: '新闻标题',
    componentType: 'input',
    //sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'authorName',
    title: '作者',
    componentType: 'input',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'compileName',
    title: '编辑',
    componentType: 'input',
    //sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'categoryName',
    title: '新闻栏目',
    componentType: 'input',
    //sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'releaseTime',
    title: '发布时间',
    componentType: 'date',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'enabledMark',
    title: '发布状态',
    componentType: 'input',
    customRender: ({ record }) => {
      const color = record.enabledMark ? 'green' : 'blue';
      const text = record.enabledMark ? t('已发布') : t('未发布');
      return h(Tag, { color: color }, () => text);
    },
    // sorter: true,
    align: 'center',
    resizable: true,
  },
];
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '54d4d5b63e954ad182b377489ce15ae2',
      field: 'briefHead',
      label: '新闻标题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入新闻标题',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        isSave: false,
        style: { width: '100%' },
      },
    },
    {
      key: '7d9fc13bda494590a4642b75931f4211',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      componentProps: { gutter: 16, justify: 'start', align: 'top', isShow: true },
      children: [
        {
          span: 12,
          list: [
            {
              key: '83f75ad3b07242f68b87839dd59d87a2',
              field: 'category',
              label: '新闻栏目',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择新闻栏目',
                showLabel: true,
                showSearch: false,
                clearable: false,
                disabled: false,
                staticOptions: [],
                defaultSelect: 'Facts',
                datasourceType: 'dic',
                params: { itemId: NewsCategoryDic.ID },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {},
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                itemId: NewsCategoryDic.ID,
                style: { width: '100%' },
                isShow: true,
              },
            },
            {
              key: 'db6247b0c70f4abaa3774aac0cf229a0',
              field: 'authorName',
              label: '作者',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入作者',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                isSave: false,
                style: { width: '100%' },
                isShow: true,
              },
            },
            {
              key: '7623d9786dee49b881457291425a7750',
              field: 'tagWord',
              label: 'Tag标签',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入Tag标签',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                isSave: false,
                style: { width: '100%' },
                isShow: true,
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '1cce31f4c5c64e6ea322d3318b9a2fea',
              field: 'releaseTime',
              label: '发布时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择发布时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: true,
                rules: [],
                events: {},
                style: { width: '100%' },
                isShow: true,
              },
            },
            {
              key: 'e17c4980ab7e4a8cbe59b6ca270653ca',
              field: 'compileName',
              label: '编辑',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入编辑',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                isSave: false,
                style: { width: '100%' },
                isShow: true,
              },
            },
            {
              key: '370d30c4565a4d25a4dd105d8a074b27',
              field: 'keyword',
              label: '关键字',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入关键字',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                isSave: false,
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
    },
    {
      key: '3ef88a44265b406a8527fb19ba87948f',
      field: 'newsContent',
      label: '内容',
      type: 'richtext-editor',
      component: 'RichTextEditor',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        disabled: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
