
import { RokeWorkTeamPageModel, RokeWorkTeamPageParams, RokeWorkTeamPageResult } from './model/BzxxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/bzxx/page',
  List = '/jcsj/bzxx/list',
  Info = '/jcsj/bzxx/info',
  RokeWorkTeam = '/jcsj/bzxx',
  
  
  
}

/**
 * @description: 查询RokeWorkTeam分页列表
 */
export async function getRokeWorkTeamPage(params: RokeWorkTeamPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeWorkTeamPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeWorkTeam信息
 */
export async function getRokeWorkTeam(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeWorkTeamPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeWorkTeam
 */
export async function addRokeWorkTeam(rokeWorkTeam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeWorkTeam,
      params: rokeWorkTeam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeWorkTeam
 */
export async function updateRokeWorkTeam(rokeWorkTeam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeWorkTeam,
      params: rokeWorkTeam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeWorkTeam（批量删除）
 */
export async function deleteRokeWorkTeam(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeWorkTeam,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




