import {
  MesProcessTypeModel,
  MesProcessTypePageParams,
  MesProcessTypePageResult,
} from './model/ProcessTypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/processtype/page',
  List = '/mes/processtype/list',
  Info = '/mes/processtype/info',
  MesProcessType = '/mes/processtype',

  Export = '/mes/processtype/export',
}

/**
 * @description: 查询MesProcessType分页列表
 */
export async function getMesProcessTypePage(
  params: MesProcessTypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProcessTypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProcessType信息
 */
export async function getMesProcessType(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProcessTypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProcessType
 */
export async function addMesProcessType(
  mesProcessType: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProcessType,
      params: mesProcessType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProcessType
 */
export async function updateMesProcessType(
  mesProcessType: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProcessType,
      params: mesProcessType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProcessType（批量删除）
 */
export async function deleteMesProcessType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProcessType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesProcessType
 */
export async function exportMesProcessType(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
