import {
  MesQbCheckproductModel,
  MesQbCheckproductPageParams,
  MesQbCheckproductPageResult,
} from './model/MesqbcheckproductModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesqbcheckproduct/page',
  List = '/mes/mesqbcheckproduct/list',
  Info = '/mes/mesqbcheckproduct/info',
  MesQbCheckproduct = '/mes/mesqbcheckproduct',
}

/**
 * @description: 查询MesQbCheckproduct分页列表
 */
export async function getMesQbCheckproductPage(
  params: MesQbCheckproductPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesQbCheckproductPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbCheckproduct信息
 */
export async function getMesQbCheckproduct(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbCheckproductModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbCheckproduct
 */
export async function addMesQbCheckproduct(
  mesQbCheckproduct: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbCheckproduct,
      params: mesQbCheckproduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbCheckproduct
 */
export async function updateMesQbCheckproduct(
  mesQbCheckproduct: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbCheckproduct,
      params: mesQbCheckproduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbCheckproduct（批量删除）
 */
export async function deleteMesQbCheckproduct(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbCheckproduct,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
