import type { TreeProps } from 'ant-design-vue';
import { useI18n } from '/@/hooks/web/useI18n';
const { t } = useI18n();
// 模板信息
const template = {
  title: t('模板信息'),
  key: 'template',
  children: [
    {
      title: t('模板名称'),
      key: '#{template_name}#',
    },
    {
      title: t('模板编号'),
      key: '#{template_code}#',
    },
    {
      title: t('模板分类'),
      key: '#{template_category}#',
    },
    {
      title: t('模板备注'),
      key: '#{template_remark}#',
    },
  ],
};
// 流程参数
const templateOfProcessArgument = {
  title: t('模板信息'),
  key: 'template',
  children: [
    {
      title: t('模板名称'),
      key: '#{template_name}#',
    },
    {
      title: t('模板编号'),
      key: '#{template_code}#',
    },
    {
      title: t('模板分类'),
      key: '#{template_category}#',
    },
    {
      title: t('模板备注'),
      key: '#{template_remark}#',
    },
  ],
};
// 流程信息
const flow = {
  title: t('流程信息'),
  key: 'flow',
  children: [
    {
      title: t('全局流程流水号'),
      key: '#{serial_number}#',
    },
    {
      title: t('全局流程ID'),
      key: '#{process_id}#',
    },
  ],
};
//发起人信息
const initiator = {
  title: t('发起人信息'),
  key: 'initiator',
  children: [
    {
      title: t('发起人id'),
      key: '#{initiator_id}#',
    },
    {
      title: t('发起人名称'),
      key: '#{initiator_user_name}#',
    },
    {
      title: t('发起人编码'),
      key: '#{initiator_code}#',
    },
    {
      title: t('发起人手机号码'),
      key: '#{initiator_mobile}#',
    },
    {
      title: t('发起人所属组织架构名称'),
      key: '#{initiator_dept_name}#',
    },
  ],
};
// 流程命名变量 流程发起时间
const namedVariableDatetime = {
  title: t('流程发起时间'),
  key: 'datetime',
  children: [
    {
      title: 'yyyyMMddHHmmss',
      key: '#{yyyy-MM-dd HH:mm:ss}#',
    },
    {
      title: 'yyyyMMdd',
      key: '#{yyyy-MM-dd}#',
    },
    {
      title: 'HHmmss',
      key: '#{HH:mm:ss}#',
    },
  ],
};
// 流程参数变量 流程发起时间
const procellvVariableDatetime = {
  title: t('流程发起时间'),
  key: 'datetime',
  children: [
    {
      title: 'yyyy-MM-dd HH-mm-ss',
      key: '#{yyyy-MM-dd HH:mm:ss}#',
    },
    {
      title: 'yyyy-MM-dd',
      key: '#{yyyy-MM-dd}#',
    },
    {
      title: 'HH:mm:ss',
      key: '#{HH:mm:ss}#',
    },
  ],
};
// 流程命名变量
export const ProcessNamedVariable: TreeProps['treeData'] = [
  template,
  flow,
  initiator,
  namedVariableDatetime,
];
// 流程参数 流程变量树
export const ProcessArgumentTreeData: TreeProps['treeData'] = [
  templateOfProcessArgument,
  flow,
  initiator,
  procellvVariableDatetime,
];
// 流程数据变量
export const ProcessDataVariable: TreeProps['treeData'] = [
  template,
  flow,
  initiator,
  namedVariableDatetime,
];
//  符号
export const symbolRuleMap = new Map([
  [
    '-',
    {
      title: '-',
      key: '#{random_-}#',
    },
  ],
]);
// 随机数
export const randomNumberRuleList = [
  {
    title: t('4位随机数'),
    key: '#{random_4}#',
  },
  {
    title: t('4位随机数(数字+字母)'),
    key: '#{random_4_mix}#',
  },
  {
    title: t('6位随机数'),
    key: '#{random_6}#',
  },
  {
    title: t('6位随机数(数字+字母)'),
    key: '#{random_6_mix}#',
  },
  {
    title: t('8位随机数'),
    key: '#{random_8}#',
  },
  {
    title: t('8位随机数(数字+字母)'),
    key: '#{random_8_mix}#',
  },
];
// 流水号
export const serialRuleList = [
  {
    title: t('4位流水号'),
    key: '#{serial_number_four}#',
  },
  {
    title: t('5位流水号'),
    key: '#{serial_number_five}#',
  },
  {
    title: t('6位流水号'),
    key: '#{serial_number_six}#',
  },
  {
    title: t('7位流水号'),
    key: '#{serial_number_seven}#',
  },
  {
    title: t('8位流水号'),
    key: '#{serial_number_eight}#',
  },
];
