import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'errorNo',
    label: '异常报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'isSysNum',
    label: '使用系统编号',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [{ label: '使用系统编号', value: '1', key: 1 }],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorState',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686656230883135490' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorLevel',
    label: '异常等级',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1688808042268565506' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'disJudge',
    label: '处置判定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1688808244736008194' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'judgeResult',
    label: '判定依据',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckStandard',
        apiId: '6967f0799cec4087bbfacae79faa0606',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'reportNo',
    label: '巡检报告编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportName',
    label: '巡检报告名称',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'errorNo',
    title: '异常报告编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '异常描述',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'errorLevel',
    title: '异常等级',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'disJudge',
    title: '处置判定',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '判定依据',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'reportNo',
    title: '巡检报告编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '巡检报告名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '异常报告创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '异常报告创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '130px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '14be909ccffc4b0d94979ad8dbfa8316',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '巡检报告信息',
      componentProps: {
        color: '',
        defaultValue: '巡检报告信息',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9f8ff71bbd3e4818a68d829f4e9cc432',
      field: 'reportId',
      label: '巡检报告ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: false,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入巡检报告ID',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8fcc6c87dd5741d7a19a724676a1eb83',
      field: 'reportNo',
      label: '巡检报告编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入巡检报告编码',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '55a772c2fd81491f96b89bb761e27bd4',
      field: 'reportName',
      label: '巡检报告名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入巡检报告名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '04c7d191ddfa470786e13f715d3dedcf',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '异常数据',
      componentProps: {
        color: '',
        defaultValue: '异常数据',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'e2e3626f99a44bf687c01e6131486a96',
      label: '',
      field: 'mesQpProcessPatrolerrordataList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQpProcessPatrolerrordataList',
        columns: [
          {
            key: 'b7723f6e394b41369b35e7175965fc50',
            title: '巡检ID',
            dataIndex: 'reportId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'report_id',
              width: '100%',
              disabled: true,
              placeholder: '请输入巡检ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '43f851570253440ca916a6f2516cd8c1',
            title: '首件报告ID',
            dataIndex: 'firstId',
            componentType: 'Input',
            show: false,
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'first_id',
              width: '100%',
              disabled: true,
              placeholder: '请输入首件报告ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },

          {
            key: '60b7c8cbae9a4f0c922543e3b76b2664',
            title: '首件报告编号',
            dataIndex: 'firstNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'first_no',
              width: '100%',
              disabled: true,
              placeholder: '请输入',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '094fc5760b9c42cd8440b2e5d1efa4a7',
            title: '销售订单ID',
            dataIndex: 'saleId',
            componentType: 'Input',
            show: false,
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'sale_id',
              width: '100%',
              disabled: true,
              placeholder: '请输入销售订单ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'f58efceec29d4f3e8c87f2d5925e8a7a',
            title: '销售订单号',
            dataIndex: 'saleNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'sale_no',
              width: '100%',
              disabled: true,
              placeholder: '请输入销售订单号',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '826263d5fb164656ba2ca610072452d3',
            title: '产品ID',
            dataIndex: 'productId',
            componentType: 'Input',
            show: false,
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'product_id',
              width: '100%',
              disabled: true,
              placeholder: '请输入产品ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'ff1c375829a6483e9eb9203d60694a13',
            title: '产品编码',
            dataIndex: 'productCode',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'product_code',
              width: '100%',
              disabled: true,
              placeholder: '请输入产品编码',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '674d4749aadb4680b45c4895901349fb',
            title: '产品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'product_name',
              width: '100%',
              disabled: true,
              placeholder: '请输入产品名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '41d62464c8a94f3987f123b46394353b',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'Input',
            show: false,
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'material_id',
              width: '100%',
              disabled: true,
              placeholder: '请输入物料ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'a2d6cd97d8c14b99a309e6598e5be51e',
            title: '物料编码',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'material_no',
              width: '100%',
              disabled: true,
              placeholder: '请输入物料编码',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '9ffc74bf304941468f933d55f2394aa4',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'material_name',
              width: '100%',
              disabled: true,
              placeholder: '请输入物料名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'ae4f6134abe8481f9725638625e59021',
            title: '巡检时间',
            dataIndex: 'checkTime',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'check_time',
              width: '100%',
              disabled: true,
              placeholder: '巡检时间请输入',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '99ae6cc567284ff1a270f429d7925c74',
            title: '检测数量',
            dataIndex: 'checkNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'check_num',
              width: '100%',
              disabled: true,
              placeholder: '请输入检测数量',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '3203753edbab4ed0ae9573e5c52d1d9e',
            title: '单位',
            dataIndex: 'checkUnit',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getUnlityList',
                method: 'GET',
                apiId: 'copy1691393740624d1194',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'keyword',
                        value: null,
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'showLabel',
                        value: 'name',
                        description: '回显字段',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: 'code',
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'queryType',
                        value: null,
                        description: '查询类型',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.name AS label,t.* FROM case_erp_unit t where state=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'check_unit',
            },
          },
          {
            key: '527702f88cc94b8686f0881801c125a5',
            title: '检测类别',
            dataIndex: 'checkType',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple', //多选
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getCheckType',
                method: 'GET',
                apiId: '7142de95ccfe43cb8beffe37a62474d2',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checktype where state=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'check_type',
            },
          },
          {
            key: '47c5c050a22e4b7b8e2d3605ae7eae4c',
            title: '检测项目',
            dataIndex: 'checkProduct',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getCheckProduct',
                method: 'GET',
                apiId: '662ac83978054327a0947126993b1175',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'check_product',
            },
          },
          {
            key: '13d5009d8b8040cf8113b2f4d5c7cdd9',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'reference_value',
              width: '100%',
              disabled: true,
              placeholder: '请输入基准值',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'da7504d643b3409bb3c6c05057416188',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'up_tolerance',
              width: '100%',
              disabled: true,
              placeholder: '请输入上公差',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'f884783b1eae464aa23cb5dbeb1064e4',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'down_tolerance',
              width: '100%',
              disabled: true,
              placeholder: '请输入下公差',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '901d01ab98ae47a59b35137ad3f92345',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'measured_value',
              width: '100%',
              disabled: true,
              placeholder: '请输入测量值',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'b8d84f9eec1842e2be3147236e0661e0',
            title: '不良数',
            dataIndex: 'errorNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'error_num',
              width: '100%',
              disabled: true,
              placeholder: '请输入不良数',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '281ac1ecc4594aaba40f269794123354',
            title: '不良处理方式',
            dataIndex: 'errorMethod',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'error_method',
              width: '100%',
              disabled: true,
              placeholder: '请输入不良处理方式',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '1edfd32a3a51484ca0b2691b5ae0d38e',
            title: '附件',
            dataIndex: 'imgFile',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              prestrainField: 'img_file',
              width: '100%',
              disabled: true,
              placeholder: '请输入附件',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择',
        showIndex: false,
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(report_id!=null&&report_id!=""){ \r\n    condition+=" and report_id=#{report_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.report_no AS label,t.* FROM mes_qp_process_patroldata t where 1=1  "+condition)',
          apiParams: [
            {
              tableInfo: [
                { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                {
                  defaultValue: 'code',
                  dataType: 'String',
                  bindType: '',
                  description: '回显字段',
                  required: false,
                  name: 'showLabel',
                  value: '',
                },
                {
                  dataType: 'String',
                  bindType: '',
                  description: '查询类型',
                  required: false,
                  name: 'queryType',
                },
                {
                  dataType: 'String',
                  bindType: 'data',
                  description: '报告ID',
                  required: false,
                  name: 'report_id',
                  value: 'report_id',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getProcessPatroldataDetailList',
          outputParams: [
            { name: 'first_no', tableTitle: '首件报告编号' },
            { name: 'sale_no', tableTitle: '销售单号' },
            { name: 'material_no', tableTitle: '物料编码' },
            { name: 'material_name', tableTitle: '物料名称' },
            { name: 'check_num', tableTitle: '检测数量' },
            { name: 'error_num', tableTitle: '不良数' },
            { name: 'measured_value', tableTitle: '测量值' },
          ],
          apiId: 'copy1691477860530d90153',
        },
        showFormBorder: true,
        span: '24',
      },
    },
    {
      key: '6e65dd256d69478a939c8cd74678ec21',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '异常报告填写',
      componentProps: {
        color: '',
        defaultValue: '异常报告填写',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'ed4d0dba4ff540128f81257f71cc1c75',
      field: 'errorNo',
      label: '异常报告编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '异常报告编号请输入',
        addonBefore: '',
        autoCodeRule: 'mesProcessCkErrorNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '399d82c9388c417c9023499a498459f8',
      field: 'isSysNum',
      label: '使用系统编号',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '使用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='errorNo';\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: 'e39b55a8d66048c58189582fb514155a',
      field: 'remark',
      label: '异常描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: true,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入异常描述',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'a4745c3aa5464fbaa9e315ebc95f1157',
      field: 'errorLevel',
      label: '异常等级',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        params: { itemId: '1688808042268565506' },
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1688808042268565506',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择异常等级',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '63b8185d1b874d2b9d9678c5b3bef32e',
      field: 'disJudge',
      label: '处置判定',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        params: { itemId: '1688808244736008194' },
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1688808244736008194',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择处置判定',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'abba4a3e2beb4348b4c07507a288df27',
      field: 'judgeResult',
      label: '判定依据',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择判定依据',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '04815c4f50d446ac86291e4a05eb719f',
      field: 'errorState',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        ifShow: true,
        valueField: 'value',
        params: { itemId: '1686656230883135490' },
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1686656230883135490',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: true,
        placeholder: '',
        staticOptions: [
          { label: '待发起', value: '0', key: 1 },
          { label: '审核中', value: '1', key: 2 },
          { label: '审核完成', value: '2', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0bc67be6d9ea41e29ddb3192f4617864',
      field: 'createUserId',
      label: '异常报告创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ecff667615854517ae49a241e1b6642e',
      field: 'createDate',
      label: '异常报告创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 3,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
