import { RuleProcessListModel } from '../api/ruleProcess/model';
import { ProcessConfigParameter } from './workflow/workflowConfig';

export enum RuleProcessNodeKey {
  START_NODE = 'start', //开始节点
  EVENT_NODE = 'event', //事件节点
  RULE_NODE = 'rule', //规则节点
  SELECT_NODE = 'select', //选择节点
  CONDITION_NODE = 'condition', //条件节点
  FOR_NODE = 'for', //for循环节点
  WHILE_NODE = 'while', //while循环节点
  DEFAULT_NODE = 'default',
  EDGE_NODE = 'custom', //连接线
  DEV_OPS_NODE = 'devOps', //运维节点
}
export enum SelectNodeResultsType {
  NODE = 1, //节点结果
  API, // API结果
  CUSTOM, // 自定义结果
  VALUE, //变量值
  DEFAULT, //默认结果
}
interface basicInfoItem {
  id: string;
  label: string;
  type: RuleProcessNodeKey;
  paramConfigs?: ProcessConfigParameter; //变量配置
}
export type InfoId = string;
export type InfoItem = basicInfoItem;
export type InfoType = RuleProcessNodeKey;
export interface RuleProcessNodeState {
  modelId: string;
  info: Map<InfoId, InfoItem>;
  infoId: InfoId;
  edgeId: InfoId;
  processInfo: RuleProcessListModel;
  lastEdgeId: number;
  lastNodeId: number;
  cateGorytreeData?: Array<any>;
}
