import { isFunction } from 'lodash-es';

// 列表特殊样式设置
export function executeListStyle(record, config) {
  try {
    const event = new Function('record', config);
    const style = event(record);
    if (style) {
      return style;
    } else {
      return '';
    }
  } catch (error) {
    return '';
  }
}

// 静态数据组件处理
export function getValue(record, column, type) {
  if (type === 'style') {
    return isFunction(column.customRender)
      ? { [column.dataIndex]: column.customRender({ record }) }
      : record;
  } else {
    return isFunction(column.customRender)
      ? column.customRender({ record })
      : record[column.dataIndex];
  }
}
