import { reactive } from 'vue';
import { getFormEnableLocke, setFormEnableLocke } from '/@/api/form/release';
export function useConcurrentLock() {
  // 并发锁
  const enableLockeData: {
    dataId: string;
    formId: string;
  } = reactive({
    dataId: '',
    formId: '',
  });
  function resetData() {
    enableLockeData.dataId = '';
    enableLockeData.formId = '';
  }
  // 查询是否有并发操作
  async function handleOpenFormEnableLockeData(id, formId) {
    enableLockeData.dataId = id;
    enableLockeData.formId = formId;
    return await getFormEnableLocke(enableLockeData.dataId, enableLockeData.formId);
    // 异常由外面接收
  }
  // 关闭
  async function handleCloseFormEnableLocke(buttonConfigs, code) {
    try {
      const hasIn = handleHasEnableLocke(buttonConfigs, code);
      if (hasIn && enableLockeData.dataId && enableLockeData.formId) {
        await setFormEnableLocke(enableLockeData.dataId, enableLockeData.formId);
        resetData();
      }
    } catch (error) {}
  }
  // 按钮配置中是否开启了并发锁
  function handleHasEnableLocke(buttonConfigs, code = 'edit') {
    if (buttonConfigs && buttonConfigs.length > 0) {
      const hasIn = buttonConfigs?.filter((ele) => {
        return ele.code == code && ele.isEnableLock;
      });
      if (hasIn.length > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
  return {
    enableLockeData,
    handleOpenFormEnableLockeData,
    handleCloseFormEnableLocke,
    handleHasEnableLocke,
  };
}
