//桌面设计
export enum DesktopComponent {
  DASHBOARD = 'Dashboard', //数据面板
  INFORMATION = 'Information', //信息列表
  CHARTLINE = 'ChartLine', //折线/柱状图
  PIE = 'Pie', //饼图
  RADAR = 'Radar', //雷达图
  GAUGE = 'Gauge', //仪表盘
  FUNNEL = 'Funnel', //漏斗图
  CHARTBAR = 'ChartBar', //柱状百分比
  MYTASK = 'MyTask', //我的任务
  TODOLIST = 'TodoList', //待办事项
  MODULES = 'Modules', //常用功能
  BANNER = 'Banner', //Banner图
  BUTTON = 'Button', // 按钮组件
  TABLE = 'Table', // 表格组件
  CATEGORY_STACK = 'CategoryStack', //甘特图
  TABSTABLE = 'TabsTable', // 多表格组件
  IMAGE = 'Image', //图片组件
  MAP = 'Map', //地图组件
  BACKGROUND = 'background', //桌面设背景图
  TITLE = 'title', //标题
  MYIFRAME = 'MyIframe', //iframe组件
  DEFAULT = 'Default',
}
// 数据面板风格类型
export enum DashboardShowType {
  ONE = '1', //风格1
  TWO = '2', //风格2
  THREE = '3', //风格3
}
// 图标类型
export enum ImgType {
  ICON = 'icon', //图标
  PICTURE = 'picture', //图片
  DEFAULT = 'default', //无
}

//布局朝向
export enum OrientType {
  HORIZONTAL = 'horizontal', //水平
  VERTICAL = 'vertical', //垂直
}
// 所在位置
export enum LocationType {
  LEFT_TOP = 1,
  RIGHT_TOP,
  LEFT_BOTTOM,
  RIGHT_BOTTOM,
  TOP_CENTER,
  BOTTOM_CENTER,
}
// 对齐方式

export enum AlignType {
  LEFT = 'left',
  CENTER = 'center',
  RIGHT = 'right',
}
// 雷达图类型
export enum RadarShapeType {
  POLYGON = 'polygon',
  CIRCLE = 'circle',
}
// 图标设置 类型
export enum LegendType {
  NONE = 'none',
  RECT = 'rect',
  CIRCLE = 'circle',
  ROUND_RECT = 'roundRect',
  TRIANGLE = 'triangle',
  DIAMOND = 'diamond',
  PIN = 'pin',
  ARROW = 'arrow',
  SQUARE = 'square',
}

//跳转地址
export enum JumpToPathType {
  PROCESSTASKS = '/task/processtasks',
}

// 按钮设置 类型
export enum ButtonType {
  SEARCH = 1,
  CREATE,
  EXECUTE,
}
// 按钮设置 执行类型
export enum ExecuteType {
  API = 1,
  JS,
  RULE,
  PUSH_MESSAGE,
}
// 表格设置 类型
export enum TableType {
  API = 1,
  FORM,
}
