import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProduct分页参数 模型
 */
export interface MesProductPageParams extends BasicPageParams {
  name: string;

  productType: string;

  productSource: string;

  productState: string;

  productStage: string;
}

/**
 * @description: MesProduct分页返回值模型
 */
export interface MesProductPageModel {
  id: string;

  code: string;

  name: string;

  productType: string;

  productSource: string;

  productState: string;

  productStage: string;

  preCost: string;

  totalCost: string;

  manageUser: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProduct表类型
 */
export interface MesProductModel {
  id: number;

  code: string;

  name: string;

  sort: number;

  productState: number;

  productType: string;

  productSource: string;

  productStage: string;

  preCost: string;

  totalCost: string;

  manageUser: string;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProduct分页返回值结构
 */
export type MesProductPageResult = BasicFetchResult<MesProductPageModel>;