import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'workId',
    label: '工单ID',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'workNo',
    label: '工单编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'taskNum',
    label: '任务总量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'sendNum',
    label: '已派数量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'stepId',
    label: '工序ID',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'stepNo',
    label: '工序编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'stepName',
    label: '工序名称',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'workId',
    title: '工单ID',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'workNo',
    title: '工单编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'taskNum',
    title: '任务总量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'sendNum',
    title: '已派数量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'stepId',
    title: '工序ID',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'stepNo',
    title: '工序编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'stepName',
    title: '工序名称',
    componentType: 'input',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'cb1d02d4b43f488eb464087dd3a2a97c',
      field: 'workId',
      label: '工单ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入工单ID工单编号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1c219e5ebe3143f98aa2550802b678b1',
      field: 'workNo',
      label: '工单编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入工单编号工单编号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '98b4b02ad00547f3889ba9242f461916',
      field: 'taskNum',
      label: '任务总量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入任务总量',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'cd51e08d87ff4e4dab9c265c796592d0',
      field: 'sendNum',
      label: '已派数量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入已派数量',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'f59b5133fa8f43d9bf314b80fd26a849',
      field: 'stepId',
      label: '工序ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入工序ID',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'dd032a5795f84420873247159934b4bd',
      field: 'stepNo',
      label: '工序编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入工序编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '0a6c9eecb5f741cd8199cd70ce659ceb',
      field: 'stepName',
      label: '工序名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: '',
        placeholder: '请输入工序名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'e4258c2f9e8642d3be6fe3ba5ad8970a',
      label: '',
      field: 'mesProOrderworkStepuserList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProOrderworkStepuserList',
        columns: [
          {
            key: '0356856ece1e4c9896c608a66ee69fd3',
            title: '指派员工',
            dataIndex: 'sendUser',
            componentType: 'User',
            defaultValue: '',
            componentProps: {
              span: '',
              width: '100%',
              defaultValue: '',
              placeholder: '请选择人员',
              userType: 0,
              prefix: '',
              suffix: 'ant-design:setting-outlined',
              showLabel: true,
              disabled: false,
              required: false,
              events: {},
            },
          },
          {
            key: '8fe1942e99c14656802d1071b527b0da',
            title: '派发数量',
            dataIndex: 'sendNum',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              max: null,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
