import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'reportNo',
    label: '首件报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'checkDate',
    label: '检验日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'checkUser',
    label: '检验员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'reportName',
    label: '报告抬头',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'saleNo',
    label: '销售单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productCode',
    label: '产品编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productName',
    label: '产品名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialNo',
    label: '物料编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialName',
    label: '物料名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'errorState',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686656230883135490' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkreportNo',
    label: '检测报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'judgeResult',
    label: '整体判定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'remark',
  //   label: '备注',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'reportNo',
    title: '首件报告编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'checkDate',
    title: '检验日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'checkUser',
    title: '检验员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '报告抬头',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'saleNo',
    title: '销售单号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productCode',
    title: '产品编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialNo',
    title: '物料编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialName',
    title: '物料名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '整体判定',
    componentType: 'radio',

    customRender: ({ record }) => {
      const staticOptions = [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ];
      return staticOptions.filter((x) => x.value === record.judgeResult)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '报告生成日期',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'c6a4b79c05bc4e488a6605ec02a2ed20',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        color: '',
        defaultValue: '基础信息',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9b416ca82c774e40bfbc78426c0df44f',
      field: 'reportNo',
      label: '首件报告编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入首件报告编号',
        addonBefore: '',
        autoCodeRule: 'mesprocessFirstNo',
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='reportNo';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        style: {},
      },
    },
    {
      key: '1decf8cad9d244898045f1e143b540e4',
      field: 'checkDate',
      label: '检验日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择检验日期',
        allowClear: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1850d7c76a2642548e294f65b1e65bf3',
      field: 'checkUser',
      label: '检验员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '5e872d8d13a84b7c965275e705233133',
      field: 'reportName',
      label: '报告抬头',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入报告抬头',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '0943210d124142a1ba31272cb748d574',
      field: 'saleId',
      label: '销售单号',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        popupType: 'associate',
        popupTitle: '选择销售订单',
        width: '100%',
        span: '',
        placeholder: '请选择销售单号',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getSaleOrderList',
          method: 'GET',
          apiId: 'copy1690958013341d31983',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.sale_number AS label,t.* FROM case_erp_sale t where audit_state=3  "+condition)',
          outputParams: [
            {
              name: 'sale_number',
              tableTitle: '销售单号',
              bindField: 'sale_no',
              show: true,
              width: 150,
            },
            { name: 'theme', tableTitle: '订单主题', bindField: '', show: true, width: 150 },
            { name: 'sale_date', tableTitle: '销售日期', bindField: '', show: true, width: 150 },
            {
              name: 'customer_name',
              tableTitle: '客户名称',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'client_person', tableTitle: '联系人', bindField: '', show: true, width: 150 },
            { name: 'client_way', tableTitle: '联系方式', bindField: '', show: true, width: 150 },
            { name: 'pay_address', tableTitle: '交货地址', bindField: '', show: true, width: 150 },
            { name: 'remark', tableTitle: '备注', bindField: '', show: true, width: 150 },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '3215ebba60bd49fcbfd47b4b6374258e',
      field: 'saleNo',
      label: '销售单号2',
      type: 'input',
      component: 'Input',
      colProps: { span: 0 },
      // ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入销售单号22',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'ba4c8cf981eb4f3c828e851661b89880',
      field: 'productId',
      label: '产品编码',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        popupType: 'associate',
        popupTitle: '产品绑定',
        col: 12,
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        width: '100%',
        apiConfig: {
          path: '/mes/getSaleOrderProductList',
          method: 'GET',
          apiId: 'copy1691460260596d60862',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'sale_id',
                  value: 'sale_id',
                  description: '销售订单ID',
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'data',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(sale_id!=null&&sale_id!=""){ \r\n    condition+=" and sale_id=#{sale_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.* FROM case_erp_sale_detail t where 1=1  "+condition)',
          outputParams: [
            {
              name: 'code',
              tableTitle: '产品编码',
              bindField: 'product_code',
              show: true,
              width: 150,
            },
            {
              name: 'name',
              tableTitle: '产品名称',
              bindField: 'product_name',
              show: true,
              width: 150,
            },
            { name: 'model', tableTitle: '规格型号', bindField: '', show: true, width: 150 },
            { name: 'unit_name', tableTitle: '单位', bindField: '', show: true, width: 150 },
            { name: 'price', tableTitle: '单价', bindField: '', show: true, width: 150 },
            { name: 'count', tableTitle: '数量', bindField: '', show: true, width: 150 },
            { name: 'discount', tableTitle: '折扣', bindField: '', show: true, width: 150 },
            { name: 'tax_rate', tableTitle: '税率', bindField: '', show: true, width: 150 },
            { name: 'tax_break', tableTitle: '税费', bindField: '', show: true, width: 150 },
            {
              name: 'after_tax_amount',
              tableTitle: '税后金额',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'delivery_date',
              tableTitle: '交付日期',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'in_store_count',
              tableTitle: '已入库数量',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'no_in_store_count',
              tableTitle: '未入库数量',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'return_count', tableTitle: '退货数量', bindField: '', show: true, width: 150 },
            {
              name: 'plan_count',
              tableTitle: '计划生产数量',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'remark', tableTitle: '备注', bindField: '', show: true, width: 150 },
          ],
        },
        disabled: false,
        placeholder: '请选择产品编码',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ece1e1b25e8e4b8f84e4e2464e4d594a',
      field: 'productCode',
      label: '产品编码2',
      type: 'input',
      component: 'Input',
      colProps: { span: 0 },
      // ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入产品编码22',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'ac5c8e4c5bfd4480bf69cfd4b8cef3a4',
      field: 'productName',
      label: '产品名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入产品名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '1a2c1d6b40e14318b28b2cf6d0e47fc7',
      field: 'materialId',
      label: '物料编码',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        popupType: 'associate',
        popupTitle: '物料绑定',
        col: 12,
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
          apiParams: [
            {
              tableInfo: [
                { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                {
                  defaultValue: 'name',
                  dataType: 'String',
                  bindType: 'value',
                  description: '回显字段：code/name',
                  required: false,
                  name: 'showLabel',
                  value: 'code',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getMaterialList',
          outputParams: [
            {
              show: true,
              bindField: 'material_no',
              name: 'code',
              width: 150,
              tableTitle: '物料编码',
            },
            {
              name: 'name',
              tableTitle: '物料名称',
              bindField: 'material_name',
              show: true,
              width: 150,
            },
            { name: 'model', tableTitle: '规格型号', bindField: '', show: true, width: 150 },
            { name: 'unit_name', tableTitle: '单位', bindField: '', show: true, width: 150 },
            { name: 'type_name', tableTitle: '物料类别', bindField: '', show: true, width: 150 },
            {
              name: 'property_name',
              tableTitle: '物料属性',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'inventory', tableTitle: '库存数量', bindField: '', show: true, width: 150 },
            { name: 'remark', tableTitle: '备注', bindField: '', show: true, width: 150 },
          ],
          apiId: '87c017a4baba48909380e9ca3e38359d',
        },
        disabled: false,
        placeholder: '请选择物料编码',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'f25d23c58c9144e893ee31c3dda0ae0e',
      field: 'materialNo',
      label: '物料编码2',
      type: 'input',
      component: 'Input',
      colProps: { span: 0 },
      // ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料编码22',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '408df2b22af743c78e44b2a1168bff52',
      field: 'materialName',
      label: '物料名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入物料名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'bbd9f30d60d74b90bcb20d22da20006f',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: '4822623f88384e78903cbcd582975ccb',
      field: 'createDate',
      label: '报告生成日期',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 2,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: '8a4f8f2b9835409d867404bb2801d5ca',
      field: 'errorState',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: '待发起', value: '0', key: 1 },
          { label: '待审核', value: '1', key: 2 },
          { label: '审核通过', value: '8', key: 3 },
          { label: '审核不通过', value: '9', key: 4 },
        ],
        events: {},
        span: '',
        params: { itemId: '1686656230883135490' },
        itemId: '1686656230883135490',
        style: { width: '100%' },
      },
    },
    {
      key: '6670d4f80efb4c37ac4b76bccea3fb5b',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测数据',
      componentProps: {
        color: '',
        defaultValue: '检测数据',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '1e7776fb21dd4253a1ceffd9f2e41495',
      label: '',
      field: 'mesQpProcessFirstdataList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQpProcessFirstdataList',
        columns: [
          {
            key: 'd611f5267c4d4914ad4af9426bca4068',
            title: '检测类别',
            dataIndex: 'checkType',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple',
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checktype where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckType',
                apiId: '7142de95ccfe43cb8beffe37a62474d2',
              },
              disabled: false,
              placeholder: '请选择',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: 'dc29488a10d649cca821ce6626628fb3',
            title: '检测项目',
            dataIndex: 'checkProduct',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple',
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckProduct',
                apiId: '662ac83978054327a0947126993b1175',
              },
              disabled: false,
              placeholder: '请选择',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '78141813d32a4e88b685a1d9fa4478ab',
            title: '检验标准',
            dataIndex: 'checkStandard',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple',
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckStandard',
                apiId: '6967f0799cec4087bbfacae79faa0606',
              },
              disabled: false,
              placeholder: '请选择',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '01f60f941b424b5ba89962f5789b6777',
            title: '检验方法',
            dataIndex: 'checkMethod',
            componentType: 'XjrSelect',
            componentProps: {
              mode: 'multiple',
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkmethod where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckmethod',
                apiId: 'c84aa22dc1f946c284b716bdfaf0b6f1',
              },
              disabled: false,
              placeholder: '请选择',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '30a628cffbaa44129de72c6fb39f2658',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '044b7fcda71740e4b43e4d0dd93f6cbb',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'e624df8ee19d401581dc790092707995',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'InputNumber',
            componentProps: {
              placeholder: '请输入',
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'f348d3a418994ab8982af2e0a7179b0c',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '多个测量值用,分割',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '38f395e2ce2a4080b45eae56ad42490f',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '0e4359fe0e094955b9b05648bfbc8699',
            title: '判定',
            dataIndex: 'judgeResult',
            componentType: 'ApiRadioGroup',
            componentProps: {
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              optionType: 'default',
              datasourceType: 'staticData',
              dicOptions: [],
              apiConfig: {},
              disabled: false,
              staticOptions: [
                { label: '合格', value: '1', key: 1 },
                { label: '不合格', value: '2', key: 2 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '1395b1af977a4b3ba1f2dca17c13ddc6',
            dataIndex: 'imgFile',
            title: '上传',
            componentType: 'Upload',
            componentProps: {
              api: uploadApi,
              defaultValue: [],
              multiple: false,
              maxSize: 5,
              showLabel: true,
              required: false,
              accept: '',
              maxNumber: 5,
              disabled: false,
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择数据',
        showIndex: true,
        useSelectButton: false,
        useCopyButton: true,
        useResetButton: true,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {},
        showFormBorder: true,
        span: '24',
      },
    },
    {
      key: '5e1afb160a374e5a8a391b0c0d055914',
      field: 'checkreportNo',
      label: '检测报告编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '检测报告编号请输入',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '17dc8a1665944b92aeec505dff9234a4',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测结果',
      componentProps: {
        color: '',
        defaultValue: '检测结果',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0ea4188a4e3d4d1c95e6498ae1d10127',
      field: 'judgeResult',
      label: '整体判定',
      type: 'radio',
      component: 'ApiRadioGroup',
      colProps: { span: 22 },
      ifShow: true,
      componentProps: {
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        optionType: 'default',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [
          { label: '合格', value: '1', key: 1 },
          { label: '不合格', value: '2', key: 2 },
        ],
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'resetBtn1',
      field: '',
      label: '按钮组件',
      type: 'button',
      component: 'Button',
      colProps: { span: 2 },
      componentProps: {
        name: '重置',
        buttonWidth: '',
        buttonHeight: '',
        prefix: '',
        suffix: '',
        disabled: false,
        events: { click: "formModel.judgeResult='';" },
        width: '',
        height: '',
      },
    },
    {
      key: '5e8cbb4d3b76447a9df98987ada7cdf1',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
