import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'parentId',
    label: '上级位置',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/getSjwz',
        method: 'GET',
        apiId: '4b8c17ba3e6a4cd6ba85e63e3917424a',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_stock_location where parent_id = \'\'";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'locationType',
    label: '位置类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '内部位置', value: '出库内部位置' },
        { key: 2, label: '虚拟位置', value: '虚拟位置' },
        { key: 3, label: '内部调拨客户位置', value: '内部调拨' },
        { key: 4, label: '供应商位置', value: '供应商位置' },
        { key: 5, label: '生产位置', value: '生产位置' },
        { key: 6, label: '中转位置', value: '中转位置' },
      ],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'completeName',
    label: '显示名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'parentId',
    title: '上级位置',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'locationType',
    title: '位置类型',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '内部位置', value: '出库内部位置' },
        { key: 2, label: '虚拟位置', value: '虚拟位置' },
        { key: 3, label: '内部调拨客户位置', value: '内部调拨' },
        { key: 4, label: '供应商位置', value: '供应商位置' },
        { key: 5, label: '生产位置', value: '生产位置' },
        { key: 6, label: '中转位置', value: '中转位置' },
      ];

      return staticOptions.filter((x) => x.value == record.locationType)[0]?.label;
    },

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'completeName',
    title: '显示名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '1884306810c14918936149fdc66077ac',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: 'fe610f88625f4064a107013880539c7e',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {
                  change:
                    "\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/getLocation', // \n  params: {\n    id: formModel.parent_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n  if (res.length > 0) { \n    var parentName = res[0].name;\n    formModel.complete_name = parentName + '/' + formModel.name;\n  } else {\n    formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n\n  }\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n});",
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '73701987bc4a471eaf01ba7f3263f94b',
              field: 'parentId',
              label: '上级位置',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '采购入库单', value: '采购入库单' },
                  { key: 2, label: '销售出库单', value: '销售出库单' },
                  { key: 3, label: '生产领料单', value: '生产领料单' },
                  { key: 4, label: '生产入库单', value: '生产入库单' },
                  { key: 5, label: '其他入库单', value: '其他入库单' },
                  { key: 6, label: '其他出库单', value: '其他出库单' },
                  { key: 7, label: '库存调拨单', value: '库存调拨单' },
                  { key: 8, label: '库存盘点单', value: '库存盘点单' },
                  { key: 9, label: '委外领料单', value: '委外领料单' },
                  { key: 10, label: '委外入库单', value: '委外入库单' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/getSjwz',
                  method: 'GET',
                  apiId: '4b8c17ba3e6a4cd6ba85e63e3917424a',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_stock_location where parent_id = \'\'";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {
                  change:
                    "\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/getLocation', // \n  params: {\n    id: formModel.parent_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n  if (res.length > 0) { \n    var parentName = res[0].name;\n    formModel.complete_name = parentName + '/' + formModel.name;\n  } else {\n    formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n\n  }\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n});",
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '600e8520e9734e51b44b6fcd93353494',
              field: 'locationType',
              label: '位置类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '内部位置', value: '出库内部位置' },
                  { key: 2, label: '虚拟位置', value: '虚拟位置' },
                  { key: 3, label: '内部调拨客户位置', value: '内部调拨' },
                  { key: 4, label: '供应商位置', value: '供应商位置' },
                  { key: 5, label: '生产位置', value: '生产位置' },
                  { key: 6, label: '中转位置', value: '中转位置' },
                ],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '17f5f8c5cb6645eba0d7f61089fd3361',
              field: 'productionLocation',
              label: '线边库',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '8f2c7ed15ba34da98771cec8d9eb9978',
              field: 'completeName',
              label: '显示名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入显示显示名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '93b40fa2500a44deb54d3b08d9e73eda',
              field: 'isShowLocation',
              label: 'App是否需要扫货位\t',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '28c29afe92d74f56bd1ccec18431a564',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 5,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '2dff5242b2f24782b4573ab20754d743',
              field: 'isMinus',
              label: '允许负库存',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
