// import { TreeStructureType } from '/@/enums/treeStructure';

import { ApiConfig } from '/@/components/ApiConfig/src/interface';
import { TreeStructureType } from '/@/enums/treeStructure';

// import { BasicFetchResult } from '/@/api/model/baseModel';
export interface StaticDataItem {
  key: string;
  label: string;
  value: string;
  expand: boolean; // 是否展开
  children: Array<StaticDataItem>;
}

export interface ApiColumnItem {
  key?: string;
  label: string;
  value?: string;
  title: string;
  width: number;
  dataIndex?: string;
}
export interface ApiItem {
  key: string;
  label: string;
  children: Array<ApiItem>;
}
export interface StaticColumnItem {
  key: string;
  dataIndex: string;
  title: string;
  width: number;
  value?: string;
}

export type TreeStructureFormState = {
  key: string;
  code: string;
  name: string;
  remark: string;
  parentIcon: string;
  childIcon: string;
  type: TreeStructureType;
  columns: Array<StaticColumnItem>;
  config: {
    staticData: Array<StaticDataItem>;
    apiData: {
      [x: string]: any;
      apiConfig: ApiConfig;
      apiColumns: Array<ApiColumnItem>;
    };
  };
};

export type TreeConfig = {
  id: string;
  name: string;
  type: TreeStructureType;
  isMultiple: Boolean;
  columns: Array<StaticColumnItem>;
  config: {
    staticData: Array<StaticDataItem>;
    apiData: {
      apiConfig: ApiConfig;
      apiColumns: Array<ApiColumnItem>;
    };
  };
};
interface treeConfig {
  bindFiled: string;
  name: string;
  value: string;
}
export type TreeConfigColumn = {
  id: string;
  name: string;
  type: TreeStructureType;
  isMultiple: Boolean;
  configTip?: string;
  config: Array<treeConfig>;
};
// export interface TemplateTypeItem {
//   value: string;
//   label: string;
// }
// export interface MessageTemplateForm {
//   id?: string;
//   code: string;
//   name: string;
//   templateType: string;
//   messageType: TreeStructureType;
//   enabledMark: number;
//   sortCode: number;
//   remark: string;
//   messageConfig: string;
// }
// export interface ConfigureItem {
//   name: string;
//   description: string;
// }
// export interface MessageContent {
//   title: string; // 消息标题
//   content: string; //消息内容
//   templateCode: string; //模板编号
//   appKey: string; //小程序
//   configs: Array<MessageContentConfigItem>; //短信配置 公众号配置
// }
// interface MessageContentConfigItem {
//   variable: string;
//   parameter: string;
// }
// export interface SearchParams {
//   keyword: string;
//   limit: number;
//   size: number;
//   templateType: string;
// }
// export interface BasicData {
//   id?: string;
//   code: string; //编码
//   name: string; //名称
//   category: string; //类别
//   apiConfig: string; //api
//   isMenu: number; //菜单
//   sortCode: number; //排序
//   parentId: string; //上级
//   icon: string; //图标
//   remark: string; //描述
//   enabledMark?: number; //启用1 禁用0
//   content: string; // 设计器Json string
// }
// export type PageResult = BasicFetchResult<BasicData>;
