import {
  MesQbChecktypeModel,
  MesQbChecktypePageParams,
  MesQbChecktypePageResult,
} from './model/MesChecktypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/meschecktype/page',
  List = '/mes/meschecktype/list',
  Info = '/mes/meschecktype/info',
  MesQbChecktype = '/mes/meschecktype',
}

/**
 * @description: 查询MesQbChecktype分页列表
 */
export async function getMesQbChecktypePage(
  params: MesQbChecktypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesQbChecktypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbChecktype信息
 */
export async function getMesQbChecktype(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbChecktypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbChecktype
 */
export async function addMesQbChecktype(
  mesQbChecktype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbChecktype,
      params: mesQbChecktype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbChecktype
 */
export async function updateMesQbChecktype(
  mesQbChecktype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbChecktype,
      params: mesQbChecktype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbChecktype（批量删除）
 */
export async function deleteMesQbChecktype(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbChecktype,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
