import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'managerId',
    label: '班组长',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getUserList',
        method: 'GET',
        apiId: '4a32e7b049c54b6fa7e88ef1cb04cbb8',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from xjr_user";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'parentId',
    label: '上级班组',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getworkteamList',
        method: 'GET',
        apiId: 'eeb487680f4a46f8b6bb1113a443fff4',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from mes_work_team";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'managerId',
    title: '班组长',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'parentId',
    title: '上级班组',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '6f173f79321c493481f43e540d39e290',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '89f7e227ec084427bd58504cf7184d06',
              field: 'code',
              label: '编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动生成',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'BZ',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'aaeb0e29ad9a4b2dba9751da63f4e12f',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '56d9862d077c4ccabde4bb773999046d',
              field: 'managerId',
              label: '班组长',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getUserList',
                  method: 'GET',
                  apiId: '4a32e7b049c54b6fa7e88ef1cb04cbb8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from xjr_user";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '1419276800524423333',
                style: { width: '100%' },
              },
            },
            {
              key: '77d198c396e24e4e8a7d37a57e00cb51',
              field: 'parentId',
              label: '上级班组',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getworkteamList',
                  method: 'GET',
                  apiId: 'eeb487680f4a46f8b6bb1113a443fff4',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from mes_work_team";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'fe9d91a4f2344ff68b0848118966e985',
              field: '',
              label: '班组二维码',
              type: 'qrcode',
              component: 'XjrQrcode',
              colProps: { span: 24 },
              defaultValue: ' ',
              componentProps: {
                span: 7,
                defaultValue: ' ',
                showLabel: true,
                isShow: true,
                codeType: 'api',
                apiConfig: {
                  path: '/gjzj/qrCode',
                  method: 'GET',
                  apiId: '',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    '// 力软平台专属：不使用encodeURIComponent，直接拼接文本\r\nvar workTeamId = "";\r\ntry {\r\n    workTeamId = @id; // 取当前班组ID\r\n} catch(e) {\r\n    workTeamId = "";\r\n}\r\n\r\n// 拼接班组信息（直接用纯文本，组件会自动生成对应二维码）\r\nvar qrContent = "暂无班组信息";\r\nif (workTeamId) {\r\n    var teamSql = "SELECT code, name FROM mes_work_team WHERE id = ?";\r\n    var teamInfo = db.selectOne(teamSql, [workTeamId]);\r\n    if (teamInfo) {\r\n        // 直接拼接纯文本，不需要编码\r\n        qrContent = "班组编号：" + (teamInfo.code || "无") + "\\n班组名称：" + (teamInfo.name || "无");\r\n    } else {\r\n        qrContent = "班组ID：" + workTeamId + "\\n信息不存在";\r\n    }\r\n}\r\n\r\n// 关键：直接返回纯文本（力软组件会自动将文本转为二维码）\r\nreturn qrContent;',
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'c88d421d89424ac79a71bd32d889fed7',
      field: 'note',
      label: '',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '此处可以填写备注或描述',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '7e364743b4bd4e249ffd3ec3259ead51',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '班组成员',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '38d17aefe9d04436afcb089f13a0a5a3',
              label: '',
              field: 'mesWorkTeamUserRelList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesWorkTeamUserRelList',
                columns: [
                  {
                    key: '6cbbc9e327df4cccb22c7bdb74bbc001',
                    title: 'id',
                    dataIndex: 'userId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'user_id',
                    },
                  },
                  {
                    key: '5cca541858134efc997cfdf98bfe5f32',
                    title: '班组成员',
                    dataIndex: 'name',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'member_name',
                    },
                  },
                  {
                    key: '55598eb1e4324950ae9fcfb6302f6538',
                    title: '编号',
                    dataIndex: 'code',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'user_code',
                    },
                  },
                  {
                    key: 'abfc9b9517684121bfbbe019011b6b87',
                    title: '工号',
                    dataIndex: 'jobNumber',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'user_code',
                    },
                  },
                  {
                    key: 'b595d86fee7944b38a37be605b7b117a',
                    title: '电话',
                    dataIndex: 'mobile',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'mobile',
                    },
                  },
                  {
                    key: '21de2c57b40e4a539b51bed6bb4ae019',
                    title: '职位',
                    dataIndex: 'positionId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'position_name',
                    },
                  },
                  {
                    key: 'a665bb78d37c409fb4d1a7cb888f1872',
                    title: '部门',
                    dataIndex: 'departmentId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'department_name',
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/bmxx/getbzcyList',
                  method: 'GET',
                  apiId: '540d7cbc36af4f299bb6cee5251ce8a8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = `\r\nSELECT\r\n    u.id                    AS value,\r\n    u.name                  AS label,\r\n\r\n    u.name                  AS member_name,      -- 班组成员\r\n    u.code                  AS user_code,        -- 编号\r\n    IFNULL(rel.job_number,'') AS job_number,      -- 工号\r\n    u.mobile                AS mobile,            -- 电话\r\n\r\n    IFNULL(pos.name,'')     AS position_name,    -- 职位\r\n    IFNULL(dept.name,'')    AS department_name   -- 部门\r\nFROM xjr_user u\r\nLEFT JOIN mes_work_team_user_rel rel\r\n       ON rel.user_id = u.id\r\nLEFT JOIN roke_position_dict pos\r\n       ON pos.id = rel.position_id\r\nLEFT JOIN xjr_department dept\r\n       ON dept.id = rel.department_id\r\nWHERE u.enabled_mark = 1\r\n  AND u.delete_mark = 0\r\n  AND u.id NOT IN (\r\n        SELECT user_id\r\n        FROM mes_work_team_user_rel\r\n        WHERE work_team_id = '#work_team_id#'\r\n  )\r\nORDER BY u.name\r\n`;\r\n\r\nreturn db.select(sql);\r\n\r\n\r\n\r\n\r\n// var sql = `\r\n// SELECT\r\n//     u.id                              AS value,\r\n//     u.name                            AS label,\r\n\r\n//     u.name                            AS member_name,   -- 班组成员\r\n//     u.code                            AS user_code,     -- 编号\r\n//     rel.job_number                    AS job_number,    -- 工号\r\n//     u.mobile                          AS mobile,        -- 电话\r\n\r\n//     pos.name                          AS position_name, -- 职位\r\n//     dept.name                         AS department_name -- 部门\r\n\r\n// FROM xjr_user u\r\n// LEFT JOIN mes_work_team_user_rel rel\r\n//        ON rel.user_id = u.id\r\n// LEFT JOIN roke_position_dict pos\r\n//        ON pos.id = rel.position_id\r\n// LEFT JOIN xjr_department dept\r\n//        ON dept.id = rel.department_id\r\n\r\n// WHERE u.enabled_mark = 1\r\n//   AND u.delete_mark = 0\r\n// `;\r\n// return db.select(sql);\r\n",
                  outputParams: [
                    { tableTitle: 'ID', name: 'user_id' },
                    { tableTitle: '班组成员', name: 'member_name' },
                    { tableTitle: '编号', name: 'user_code' },
                    { tableTitle: '工号', name: 'user_code' },
                    { tableTitle: '电话', name: 'mobile' },
                    { tableTitle: '职位', name: 'position_name' },
                    { name: 'department_name', tableTitle: '部门' },
                  ],
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: true,
                buttonName: '新增',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
