import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'companyId',
    label: '公司',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getCompanyList',
        method: 'GET',
        apiId: 'copy1765431632890d13798',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as lable,name as value from res_company";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'upDepartment',
    label: '上级部门',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getList',
        method: 'GET',
        apiId: '484584e786864e0f90ec8e4eb84fa93a',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as lable,name as value from roke_department";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'managerId',
    label: '部门组长',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getEmployeeList',
        method: 'GET',
        apiId: 'copy1765432049337d61208',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select *,id as lable,name as value from roke_employee";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'companyId',
    title: '公司',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'upDepartment',
    title: '上级部门',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'managerId',
    title: '部门组长',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
      isClick: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
      isClick: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'e10b2b8b72194135bf863dfb87083b5f',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: 'ebfec1c680f140ff9db90cc274c2e115',
              field: 'code',
              label: '编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入编号',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '59ca5c4881954ef18d2453206aa04edb',
              field: 'companyId',
              label: '公司',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as lable,name as value from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '1dad181c01d04a0ea70b2ecaebf1db44',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'aed98da62cfa4b7389b227221dcc87cb',
              field: 'upDepartment',
              label: '上级部门',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择上级部门',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getList',
                  method: 'GET',
                  apiId: '484584e786864e0f90ec8e4eb84fa93a',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as lable,name as value from roke_department";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '93ff0bc563174dc6a9c764d0d8695779',
              field: 'managerId',
              label: '部门组长',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择部门组长',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as lable,name as value from roke_employee";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: null,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '1d86ca9508db4eaaa65dfb7e67bf1880',
      field: 'note',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '99%',
        span: 2,
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 3,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '99%' },
      },
    },
    {
      key: 'c85b705f89a04f1fad398e44a87fc1c6',
      label: '部门成员',
      field: 'rokeDepartmentLineList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'rokeDepartmentLineList',
        columns: [
          {
            key: '6730656c4fbc41abb21529e0ccd129fd',
            title: '班组成员',
            dataIndex: 'employeeId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择下拉选择',
              showLabel: true,
              showSearch: false,
              isMultiple: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/bmxx/getEmployeeList',
                method: 'GET',
                apiId: 'copy1765432049337d61208',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var sql="select *,id as lable,name as value from roke_employee";\r\nreturn db.select(sql);',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {
                change:
                  "// 调用接口并获取返回值\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/bmxx/getEmployeeById',\n  params: {\n    id: formModel.roke_department_lineList[index].employee_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n  if (res.length>0) { formModel.roke_department_lineList[index].dan_xing_wen_ben4274=res[0].code;\n    formModel.roke_department_lineList[index].dan_xing_wen_ben8110=res[0].job_number;\n                     formModel.roke_department_lineList[index].dan_xing_wen_ben7047=res[0].phone;\n                     formModel.roke_department_lineList[index].dan_xing_wen_ben3180=res[0].position_id;\n                     formModel.roke_department_lineList[index].dan_xing_wen_ben7396=res[0].team_id;\n                     formModel.roke_department_lineList[index].dan_xing_wen_ben9431=res[0].skill_level_id\n    \n    // 示例：将返回值赋值给表单字段（力软表单场景）\n    // formActionType.setFormData({\n    //   dictName: data.dictName, // 假设表单有dictName字段\n    //   dictValue: data.dictValue\n    // });\n  } else {\n    formActionType.showMessage('获取员工信息失败')\n  }\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  alert('请求失败，请检查网络或接口地址');\n});",
              },
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
              listStyle: "return 'border: 0'",
            },
          },
          {
            key: '15cd1e63de0b45b7b2c880e5b89d5ebf',
            title: '编号',
            dataIndex: 'danXingWenBen4274',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入编号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '798aa6acd21545ea8fbe780b19a7c9fe',
            title: '工号',
            dataIndex: 'danXingWenBen8110',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '1b15744f7dc34a34acfa3bce4e052c0d',
            title: '电话',
            dataIndex: 'danXingWenBen7047',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入电话',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'a1a763e6553240198d0f9e40d3fa14eb',
            title: '职位',
            dataIndex: 'danXingWenBen3180',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入职位',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: 'd263efdb285d44e3922ec9a7ae2db55d',
            title: '班组',
            dataIndex: 'danXingWenBen7396',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入班组',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '021dcae521c644d4ba82068fc004248f',
            title: '技能等级',
            dataIndex: 'danXingWenBen9431',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入技能等级',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: 2,
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: false,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: false,
        isImport: false,
        isDeleteSelected: false,
        isListView: false,
        viewList: [],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {},
        showPagenation: true,
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
