import { TableConfig } from './../../../model/generator/tableConfig';
import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';
import { TableStructureConfig } from '/@/model/generator/tableStructureConfig';

/**
 * @description: AiCreateTable分页参数 模型
 */
export interface AiCreateTablePageParams extends BasicPageParams {
  name: string;
}

/**
 * @description: AiCreateTable分页返回值模型
 */
export interface AiCreateTablePageModel {
  id: string;

  name: string;

  code: string;

  remark: string;
}

/**
 * @description: AiCreateTable分页返回值结构
 */
export type AiCreateTablePageResult = BasicFetchResult<AiCreateTablePageModel>;

export interface AiTableModal {
  id?: string;
  code: string;
  columName?: string;
  databaseId: string;
  name: string;
  remark?: string;
  tableName: string;
  aiTableStructureConfig: {
    tableStructureConfigs: TableStructureConfig[];
    tableConfigs: TableConfig[];
  };
}
