import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cm',
    label: '类型名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'pid',
    label: '父类别',
    defaultValue: undefined,
    component: 'ApiCascader',
    componentProps: {
      apiConfig: {
        path: '/jcxx/cplx/getAllCPLXTree_zujian',
        method: 'GET',
        apiId: 'copy1770283483454d34933',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'code',
                value: null,
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql = ""\r\n    + "select id,"\r\n    + " pid as \'parentId\', "\r\n    + " id as \'value\', "\r\n    + " cm as \'label\' "\r\n    + "from mes_base_cplx "\r\n    + "where delete_mark = 0 "\r\n    + "order by pid, id";\r\nvar list = db.select(sql);\r\n\r\nif (list == null || list.size() == 0) {\r\n    return [];\r\n}\r\nvar map = new HashMap();\r\nvar idx = 0;\r\nwhile (idx < list.size()) {\r\n    var itemNode = list.get(idx);\r\n    itemNode.children = [];\r\n    map.put(itemNode.id, itemNode);\r\n    idx = idx + 1;\r\n}\r\nvar dataList = [];\r\nidx = 0;\r\nwhile (idx < list.size()) {\r\n    var itemNode = list.get(idx);\r\n    if (itemNode.parentId == null || itemNode.parentId == \'0\' || itemNode.parentId == \'\') {\r\n        dataList.add(itemNode);\r\n    } else {\r\n        var parentNode = map.get(itemNode.parentId);\r\n        if (parentNode != null) {\r\n            parentNode.children.add(itemNode);\r\n        } else {\r\n            dataList.add(itemNode);\r\n        }\r\n    }\r\n    idx = idx + 1;\r\n}\r\nreturn dataList\r\n',
      },
      showFormat: 'all',
      separator: '/',
      selectedConfig: 'any',
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cm',
    title: '类型名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'pid',
    title: '父类别',
    componentType: 'cascader',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'bh',
    title: '类型编码',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'paixu',
    title: '排序',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bz',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'd8a01b822ee141d6913c8db73c37d07a',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'db121a41243b404a90482cb07852313a',
              field: 'cm',
              label: '类型名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入类型名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '8eaade4e896f41d1a0d1c0374a7268c7',
              field: 'pid',
              label: '父类别',
              type: 'cascader',
              component: 'ApiCascader',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择父类别',
                showFormat: 'all',
                separator: '/',
                selectedConfig: 'any',
                disabled: false,
                allowClear: false,
                showLabel: true,
                apiConfig: {
                  path: '/jcxx/cplx/getAllCPLXTree_zujian',
                  method: 'GET',
                  apiId: 'copy1770283483454d34933',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'code',
                          value: null,
                          description: null,
                          required: false,
                          dataType: 'String',
                          type: null,
                          defaultValue: null,
                          validateType: null,
                          error: null,
                          expression: null,
                          children: null,
                          bindType: '',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql = ""\r\n    + "select id,"\r\n    + " pid as \'parentId\', "\r\n    + " id as \'value\', "\r\n    + " cm as \'label\' "\r\n    + "from mes_base_cplx "\r\n    + "where delete_mark = 0 "\r\n    + "order by pid, id";\r\nvar list = db.select(sql);\r\n\r\nif (list == null || list.size() == 0) {\r\n    return [];\r\n}\r\nvar map = new HashMap();\r\nvar idx = 0;\r\nwhile (idx < list.size()) {\r\n    var itemNode = list.get(idx);\r\n    itemNode.children = [];\r\n    map.put(itemNode.id, itemNode);\r\n    idx = idx + 1;\r\n}\r\nvar dataList = [];\r\nidx = 0;\r\nwhile (idx < list.size()) {\r\n    var itemNode = list.get(idx);\r\n    if (itemNode.parentId == null || itemNode.parentId == \'0\' || itemNode.parentId == \'\') {\r\n        dataList.add(itemNode);\r\n    } else {\r\n        var parentNode = map.get(itemNode.parentId);\r\n        if (parentNode != null) {\r\n            parentNode.children.add(itemNode);\r\n        } else {\r\n            dataList.add(itemNode);\r\n        }\r\n    }\r\n    idx = idx + 1;\r\n}\r\nreturn dataList\r\n',
                },
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'e0ca71c675704d2db7029f845aba3f86',
              field: 'bh',
              label: '类型编码',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请输入类型编码',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'cplx',
                required: true,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'ec842ddda4a14613b585f6e9904257ec',
              field: 'paixu',
              label: '排序',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入排序',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '9501144a835544dab10f5dd0b1fbf0ca',
      field: 'bz',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: true,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
