import { LocationType } from '/@/enums/desktop';
import { DesktopInfoItem } from '/@/model/mobileDesign/designer';

/**
 * 构建app数据设计页代码
 * @param model
 * @param _tableInfo
 * @returns
 */
export function buildAppDataCode(model: Array<DesktopInfoItem>, isHome: number): string {
  const compMap: any[] = [];
  let importCode = '';
  let configCode = '';
  let code = `<template>
	<view class="data-display" ${isHome ? `style="padding-bottom:60px"` : ``}>
  `;
  if (model.length) {
    model.forEach((o, i) => {
      const key = o.type;
      if (!compMap.includes(key)) compMap.push(key);
      const config: any = o.config;
      const apiConfig = config.apiConfig
        ? `apiConfig: { 
        name: "${config.apiConfig.name}",
        method: "${config.apiConfig.method}",
        path: "${config.apiConfig.path}",
        requestParamsConfigs: ${JSON.stringify(config.apiConfig.requestParamsConfigs) || []},
        requestHeaderConfigs: ${JSON.stringify(config.apiConfig.requestHeaderConfigs) || []},
        requestBodyConfigs:${JSON.stringify(config.apiConfig.requestBodyConfigs) || []}
      },`
        : '';
      const idx = i > 0 ? `_${i}` : '';
      switch (key) {
        case 'Dashboard':
          code += `<Dashboard :config="dashboardConfig${idx}"></Dashboard>
          `;
          configCode += `const dashboardConfig${idx} = ref({   
            ${apiConfig}
            numColor: "${config.numColor}",
            labelColor: "${config.labelColor}",
            dashboard: ${JSON.stringify(config.dashboard) || []}
          });
          `;
          break;
        case 'Banner':
          code += `<view style="margin: 0 -10px 10px;">
          <Banner :config="bannerConfig${idx}"></Banner>
          </view>
          `;

          const imgs: string[] = config.imgs.map((k) => {
            return k.url === '/src/assets/images/design/logo.png' ? '/static/img/logo.png' : k.url;
          });
          configCode += `const bannerConfig${idx} = ref({
            height: ${o.h},
            imgs: ${JSON.stringify(imgs)},
          });
          `;
          break;
        case 'ChartLine':
          code += `<LineChart :config="lineConfig${idx}"></LineChart>
          `;
          const Llegend = getLegend(config.legend);
          const dataList: any[] = [];
          config.dataList.forEach((k) => {
            const yAxis: any[] = [];
            config.yAxis.forEach((j, i) => {
              yAxis.push({
                type: 'value', //value数值,categories类别
                position: j.position,
                title: j.name,
                titleFontColor: j.nameTextStyle.color,
                titleFontSize: j.nameTextStyle.fontSize,
                // min: j.min,
                // max: j.max,
                format: i === 0 ? 'lineYAxis' : 'lineYAxisTwo',
                axisFormat: j.axisLabel.formatter,
                fontColor: j.axisLabel.color,
                axisLine: j.axisLine.show,
                axisLineColor: j.axisLine.lineStyle.color,
              });
            });

            dataList.push({
              title: k.title,
              valueKey: k.valueKey,
              apiConfig: k.apiConfig,
              indicator: k.indicator,
              options: {
                extra: {
                  mix: {
                    column: {
                      seriesGap: 120,
                    },
                    area: {
                      gradient: true,
                      opacity: 6,
                    },
                  },
                },
                yAxis: {
                  data: yAxis,
                },
                xAxis: {
                  title: config.xAxis[0].name,
                  titleFontColor: config.xAxis[0].nameTextStyle.color,
                  titleFontSize: config.xAxis[0].nameTextStyle.fontSize,
                  fontColor: config.xAxis[0].axisLabel.color,
                  axisLine: config.xAxis[0].axisLine.show,
                  axisLineColor: config.xAxis[0].axisLine.lineStyle.color,
                  format: 'lineXAxis',
                  axisFormat: config.xAxis[0].axisLabel.formatter,
                },
                dataLabel: config.label.show,
                legend: Llegend,
              },
            });
          });
          configCode += `const lineConfig${idx} = ref({
            height: ${o.h},
            title: "${config.title}", 
            condition: ${JSON.stringify(config.condition)},
            count: ${JSON.stringify(config.count)},
            dataList:${JSON.stringify(dataList)}, 
            line: ${JSON.stringify(config.line)},
            fontSize:${config.label.fontSize},
            fontColor:"${config.label.color}",    
          });
          `;
          break;
        case 'Pie':
          code += `<PieChart :config="pieConfig${idx}"></PieChart>
          `;
          const Plegend = getLegend(config.echarts.legend);
          const type =
            config.echarts.series[0].radius[0] &&
            config.echarts.series[0].radius[0].split('%')[0] > 0
              ? 'ring'
              : config.echarts.series[0].roseType
              ? 'rose'
              : 'pie';
          let opts = '';
          if (type == 'pie') {
            opts = `pie: { 
              "customRadius": ${config.echarts.series[0].radius[1].split('%')[0]},
              "labelWidth": 10,
              "border": false 
            }`;
          } else if (type == 'ring') {
            opts = `ring: {
              ringWidth: ${config.echarts.series[0].radius[0].split('%')[0]}, //内圈大小  
              labelWidth: 10,
              border: false, 
              customRadius:${config.echarts.series[0].radius[1].split('%')[0]} //外圈大小 
            }`;
          } else {
            opts = `rose: {
              type: "${config.echarts.series[0].roseType}",
              minRadius: ${config.echarts.series[0].radius[0].split('%')[0]}, 
              labelWidth: 10,
              border: false, 
            }`;
          }
          configCode += `const pieConfig${idx} = ref({   
            ${apiConfig}
            labelKey: "${config.labelKey}", 
            valueKey: "${config.valueKey}", 
            title: "${config.title}", 
            height: ${o.h}, 
            fontSize:${config.echarts.series[0].label.fontSize},
            fontColor:"${config.echarts.series[0].label.color}",          
            pieType:"${type}", //rose玫瑰图，pie饼图，ring环形图
            options:{
              dataLabel: ${config.echarts.series[0].label.show},
              labelFormat:"${config.echarts.series[0].label.formatter}",
              legend: ${JSON.stringify(Plegend)},
              color: ${JSON.stringify(config.colors)}, 
              extra: {${opts}}
            }
          });
          `;
          break;
        case 'Radar':
          code += `<RadarChart :config="radarConfig${idx}"></RadarChart>
          `;
          const Rlegend = getLegend(config.echarts.legend);
          configCode += `const radarConfig${idx} = ref({   
            ${apiConfig}
            labelKey: "${config.labelKey}", 
            title: "${config.title}", 
            height: ${o.h}, 
            indicator:${JSON.stringify(config.echarts.radar.indicator) || []}, 
            pointShape:"${config.echarts.series[0].symbol}",
            options:{
              dataLabel: ${config.echarts.series[0].label.show},
              legend: ${JSON.stringify(Rlegend)},
              color: ${JSON.stringify(config.colors)}, 
              extra: {
                "radar": {
                  radius:${config.echarts.radar.radius},
                  "gridType": "circle",
                  "gridColor": "#CCCCCC",
                  border:true, 
                  "opacity": ${config.echarts.showAreaStyle}, 
                },
              }
            }
          });
          `;
          break;
        case 'Gauge':
          code += `<GaugeChart :config="gaugeConfig${idx}"></GaugeChart>
          `;
          configCode += `const gaugeConfig${idx} = ref({   
            ${apiConfig}
            labelKey: "${config.labelKey}", 
            title: "${config.title}", 
            height: ${o.h},
            valueKey: "${config.valueKey}", 
          });
          `;
          break;
        case 'Funnel':
          code += `<FunnelChart :config="funnelConfig${idx}"></FunnelChart>
          `;
          const Flegend = getLegend(config.echarts.legend);
          configCode += `const funnelConfig${idx} = ref({   
            ${apiConfig}
            fontSize:${config.echarts.series[0].label.fontSize},
            fontColor:"${config.echarts.series[0].label.color}",       
            options:{
              labelFormat:"${config.echarts.series[0].label.formatter}",
              dataLabel:${config.echarts.series[0].label.show},
              color: ${JSON.stringify(config.colors)}, 
              padding: [${config.echarts.series[0].top || 0},${
            config.echarts.series[0].right || 0
          },${config.echarts.series[0].bottom || 0},${config.echarts.series[0].left || 0}],
              legend:${JSON.stringify(Flegend)},
              extra: {
                funnel: {
                  activeOpacity: 0.3,
                  activeWidth: 10,
                  border: true,
                  borderWidth: ${config.echarts.series[0].gap},
                  borderColor: "#FFFFFF",
                  fillOpacity: 1,
                  labelAlign: "${
                    config.echarts.series[0].label.show
                      ? config.echarts.series[0].label.position
                      : 'left'
                  }",
                  type: "${
                    config.echarts.series[0].sort == 'descending' ? 'triangle' : 'pyramid'
                  }"  //triangle倒三角，pyramid金字塔
                }
              }
            }, 
            labelKey: "${config.labelKey}", 
            title: "${config.title}", 
            height: ${o.h},
            valueKey: "${config.valueKey}", 
          });
          `;
          break;
        case 'ChartBar':
          code += `<BarChart :config="barConfig${idx}"></BarChart>
          `;
          configCode += `const barConfig${idx} = ref({   
            ${apiConfig} 
            labelKey: "${config.labelKey}",
            targetKey:"${config.targetKey}",
            title: "${config.title}",
            height: ${o.h},
            unit: "${config.unit}",
            valueKey: "${config.valueKey}"
          });
          `;
          break;
        case 'MyTask':
          code += `<MyTask :config="taskConfig${idx}"></MyTask>
          `;
          configCode += `const taskConfig${idx} = ref({
            title: "${config.title}", 
          });
          `;
          break;
        case 'TodoList':
          code += `<TodoList :config="todoConfig${idx}"></TodoList>
          `;
          configCode += `const todoConfig${idx} = ref({
            title: "${config.title}",
            maxRows: ${config.maxRows},
          });
          `;
          break;
        case 'Modules':
          code += `<Modules :config="modulesConfig${idx}"></Modules>
          `;
          configCode += `const modulesConfig${idx} = ref({
            title: "${config.title}",
            functions: ${JSON.stringify(config.functions)},
          });
          `;
          break;
        default:
          break;
      }
    });
    compMap.forEach((o) => {
      switch (o) {
        case 'Dashboard':
          importCode += `import Dashboard from '@/components/dataDisplay/Dashboard.vue';
          `;
          break;
        case 'Banner':
          importCode += `import Banner from '@/components/dataDisplay/Banner.vue';
          `;
          break;
        case 'ChartLine':
          importCode += `import LineChart from '@/components/dataDisplay/LineChart.vue';
          `;
          break;
        case 'Pie':
          importCode += `import PieChart from '@/components/dataDisplay/PieChart.vue';
          `;
          break;
        case 'Radar':
          importCode += `import RadarChart from '@/components/dataDisplay/RadarChart.vue';
          `;
          break;
        case 'Gauge':
          importCode += `import GaugeChart from '@/components/dataDisplay/GaugeChart.vue';
          `;
          break;
        case 'Funnel':
          importCode += `import FunnelChart from '@/components/dataDisplay/FunnelChart.vue';
          `;
          break;
        case 'ChartBar':
          importCode += `import BarChart from '@/components/dataDisplay/BarChart.vue';
          `;
          break;
        case 'MyTask':
          importCode += `import MyTask from '@/components/dataDisplay/MyTask.vue';
          `;
          break;
        case 'TodoList':
          importCode += `import TodoList from '@/components/dataDisplay/TodoList.vue';
          `;
          break;
        case 'Modules':
          importCode += `import Modules from '@/components/dataDisplay/Modules.vue';
          `;
          break;
        default:
          break;
      }
    });
  }

  code += `</view>
</template>

<script setup>
import { ref } from 'vue';
${importCode}
${configCode} 
</script>

<style></style>`;

  return code;
}

function getLegend(config) {
  let left = 'left';
  let top = 'bottom';
  if (config.position == LocationType.LEFT_TOP) {
    left = config.orient == 'horizontal' ? 'left' : 'top';
    top = config.orient == 'horizontal' ? 'top' : 'left';
  } else if (config.position == LocationType.RIGHT_TOP) {
    left = config.orient == 'horizontal' ? 'right' : 'top';
    top = config.orient == 'horizontal' ? 'top' : 'right';
  } else if (config.position == LocationType.LEFT_BOTTOM) {
    left = config.orient == 'horizontal' ? 'left' : 'bottom';
    top = config.orient == 'horizontal' ? 'bottom' : 'left';
  } else if (config.position == LocationType.RIGHT_BOTTOM) {
    left = config.orient == 'horizontal' ? 'right' : 'bottom';
    top = config.orient == 'horizontal' ? 'bottom' : 'right';
  } else if (config.position == LocationType.TOP_CENTER) {
    left = 'center';
    top = config.orient == 'horizontal' ? 'top' : 'left';
  } else if (config.position == LocationType.BOTTOM_CENTER) {
    left = 'center';
    top = config.orient == 'horizontal' ? 'bottom' : 'left';
  }
  const legend = {
    show: config.show,
    position: top,
    float: left,
    margin: config.padding,
    legendShape: config.icon,
    fontColor: config.textStyle.color,
  };
  return legend;
}
