
import { MesQuailtyProjectPageModel, MesQuailtyProjectPageParams, MesQuailtyProjectPageResult } from './model/ZjxmModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/zlgl/zjxm/page',
  List = '/zlgl/zjxm/list',
  Info = '/zlgl/zjxm/info',
  MesQuailtyProject = '/zlgl/zjxm',
}

/**
 * @description: 查询MesQuailtyProject分页列表
 */
export async function getMesQuailtyProjectPage(params: MesQuailtyProjectPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQuailtyProjectPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQuailtyProject信息
 */
export async function getMesQuailtyProject(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQuailtyProjectPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQuailtyProject
 */
export async function addMesQuailtyProject(mesQuailtyProject: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQuailtyProject,
      params: mesQuailtyProject,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQuailtyProject
 */
export async function updateMesQuailtyProject(mesQuailtyProject: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQuailtyProject,
      params: mesQuailtyProject,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQuailtyProject（批量删除）
 */
export async function deleteMesQuailtyProject(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQuailtyProject,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




