
import { MesProductionTaskPageModel, MesProductionTaskPageParams, MesProductionTaskPageResult } from './model/ScrwModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/scrw/page',
  List = '/scgl/scrw/list',
  Info = '/scgl/scrw/info',
  MesProductionTask = '/scgl/scrw',
  
  
  
}

/**
 * @description: 查询MesProductionTask分页列表
 */
export async function getMesProductionTaskPage(params: MesProductionTaskPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionTaskPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProductionTask信息
 */
export async function getMesProductionTask(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionTaskPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProductionTask
 */
export async function addMesProductionTask(mesProductionTask: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProductionTask,
      params: mesProductionTask,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProductionTask
 */
export async function updateMesProductionTask(mesProductionTask: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProductionTask,
      params: mesProductionTask,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProductionTask（批量删除）
 */
export async function deleteMesProductionTask(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProductionTask,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




