import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQbCheckstandard分页参数 模型
 */
export interface MesQbCheckstandardPageParams extends BasicPageParams {
  code: string;

  name: string;

  templateState: string;

  publishDate: string;

  executeDate: string;

  state: string;
}

/**
 * @description: MesQbCheckstandard分页返回值模型
 */
export interface MesQbCheckstandardPageModel {
  id: string;

  code: string;

  name: string;

  templateState: string;

  publishDate: string;

  executeDate: string;

  state: string;

  createUserId: string;

  createDate: string;

  remark: string;
}

/**
 * @description: MesQbCheckstandard表类型
 */
export interface MesQbCheckstandardModel {
  id: number;

  isSysNum: string;

  code: string;

  name: string;

  templateState: string;

  state: number;

  remark: string;

  sort: number;

  publishDate: string;

  executeDate: string;

  imgFiles: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQbCheckstandard分页返回值结构
 */
export type MesQbCheckstandardPageResult = BasicFetchResult<MesQbCheckstandardPageModel>;
