import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesBaseFactory分页参数 模型
 */
export interface MesBaseFactoryPageParams extends BasicPageParams {
  factoryCode: string;

  factoryName: string;

  factoryManage: string;

  factoryAddress: string;

  factoryId: string;

  carId: string;

  remark: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesBaseFactory分页返回值模型
 */
export interface MesBaseFactoryPageModel {
  id: string;

  factoryCode: string;

  factoryName: string;

  factoryManage: string;

  factoryAddress: string;

  factoryId: string;

  carId: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesBaseFactory表类型
 */
export interface MesBaseFactoryModel {
  id: number;

  parentId: number;

  factoryId: number;

  carId: number;

  factoryCode: string;

  factoryType: string;

  factoryName: string;

  factoryAddress: string;

  factoryManage: string;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesBaseFactory分页返回值结构
 */
export type MesBaseFactoryPageResult = BasicFetchResult<MesBaseFactoryPageModel>;