
import { MesShiftHandoverPageModel, MesShiftHandoverPageParams, MesShiftHandoverPageResult } from './model/JjbglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jjbgl/jjbgl/page',
  List = '/jjbgl/jjbgl/list',
  Info = '/jjbgl/jjbgl/info',
  MesShiftHandover = '/jjbgl/jjbgl',
  
  
  
}

/**
 * @description: 查询MesShiftHandover分页列表
 */
export async function getMesShiftHandoverPage(params: MesShiftHandoverPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesShiftHandoverPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesShiftHandover信息
 */
export async function getMesShiftHandover(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesShiftHandoverPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesShiftHandover
 */
export async function addMesShiftHandover(mesShiftHandover: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesShiftHandover,
      params: mesShiftHandover,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesShiftHandover
 */
export async function updateMesShiftHandover(mesShiftHandover: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesShiftHandover,
      params: mesShiftHandover,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesShiftHandover（批量删除）
 */
export async function deleteMesShiftHandover(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesShiftHandover,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




