
import { MesWarehouseProductNumLogPageModel, MesWarehouseProductNumLogPageParams, MesWarehouseProductNumLogPageResult } from './model/ZbrzModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/zbrz/page',
  List = '/ckgl/zbrz/list',
  Info = '/ckgl/zbrz/info',
  MesWarehouseProductNumLog = '/ckgl/zbrz',
  
  
  
}

/**
 * @description: 查询MesWarehouseProductNumLog分页列表
 */
export async function getMesWarehouseProductNumLogPage(params: MesWarehouseProductNumLogPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductNumLogPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseProductNumLog信息
 */
export async function getMesWarehouseProductNumLog(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductNumLogPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseProductNumLog
 */
export async function addMesWarehouseProductNumLog(mesWarehouseProductNumLog: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseProductNumLog,
      params: mesWarehouseProductNumLog,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseProductNumLog
 */
export async function updateMesWarehouseProductNumLog(mesWarehouseProductNumLog: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseProductNumLog,
      params: mesWarehouseProductNumLog,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseProductNumLog（批量删除）
 */
export async function deleteMesWarehouseProductNumLog(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseProductNumLog,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




