
import { MesWarehouseReturnPageModel, MesWarehouseReturnPageParams, MesWarehouseReturnPageResult } from './model/TkglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/tkgl/page',
  List = '/ckgl/tkgl/list',
  Info = '/ckgl/tkgl/info',
  MesWarehouseReturn = '/ckgl/tkgl',
  
  
  Export = '/ckgl/tkgl/export',
  
}

/**
 * @description: 查询MesWarehouseReturn分页列表
 */
export async function getMesWarehouseReturnPage(params: MesWarehouseReturnPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseReturnPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseReturn信息
 */
export async function getMesWarehouseReturn(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseReturnPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseReturn
 */
export async function addMesWarehouseReturn(mesWarehouseReturn: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseReturn,
      params: mesWarehouseReturn,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseReturn
 */
export async function updateMesWarehouseReturn(mesWarehouseReturn: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseReturn,
      params: mesWarehouseReturn,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseReturn（批量删除）
 */
export async function deleteMesWarehouseReturn(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseReturn,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseReturn
 */
export async function exportMesWarehouseReturn(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

