import { httpRequest } from '/@/api/sys/api';
import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Page = 'wbw/getOrderTableData',
  DeleteOrderUrl = 'wbw/deleteOrderData',
  OrderDetail = 'wbw/getOrderProductData',
  GoodsList = 'wbw/getProductData',
  Order = '/order',
}
/**
 * @description: 查询订单列表
 */
export async function getOrderList(params: { keyword: string; userID: string }) {
  // key 关键字  userID 用户id
  const url =
    Api.Page +
    '' +
    '?key=' +
    (params.keyword ? params.keyword : '') +
    '&userID=' +
    (params.userID ? params.userID : '');
  return httpRequest(
    {
      requestUrl: url,
      requestType: 'get',
    },
    {},
  );
}

/**
 * @description: 查询商品列表
 */
export async function getGoodsList() {
  return httpRequest(
    {
      requestUrl: Api.GoodsList,
      requestType: 'get',
    },
    {},
  );
}
/**
 * @description: 删除订单
 */
export async function deleteOrder(id) {
  const url = Api.DeleteOrderUrl + '?OrderID=' + id;
  return httpRequest(
    {
      requestUrl: url,
      requestType: 'get',
    },
    {},
  );
}
/**
 * @description: 查询订单列表
 */
export async function getOrderDetail(id) {
  const url = Api.OrderDetail + '?OrderID=' + id;
  return httpRequest(
    {
      requestUrl: url,
      requestType: 'get',
    },
    {},
  );
}

/**
 * @description: 新增
 */
export async function add(params: any, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.Order,
      params: params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 新增
 */
export async function edit(params: any, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.Order,
      params: params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
