import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'bh',
    label: '编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'fzr',
    label: '负责人',
    defaultValue: undefined,
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
  },

  {
    field: 'fams',
    label: '描述',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'mc',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'fasx',
    label: '方案时效',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2008724534063562753' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'jclx',
    label: '检查类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2008724308439367682' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'zjfs',
    label: '质检方式',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2001225699288457217' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'bh',
    title: '编号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'mc',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'fzr',
    title: '负责人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'fasx',
    title: '方案时效',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jclx',
    title: '检查类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zjfs',
    title: '质检方式',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'fams',
    title: '描述',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'left',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'fdab107ce8954bb6a8291bf0475853ba',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'bf21f2a2c9d548fd87eaf76d43f66ae5',
              field: 'bh',
              label: '编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动生成',
                prefix: 'ant-design:slack-outlined',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'ZJFA',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'f91edfede01f476ba0762d833b7ac181',
              field: 'fzr',
              label: '负责人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                width: '100%',
                defaultValue: '',
                placeholder: '请选择负责人',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:expand-outlined',
                showLabel: true,
                disabled: false,
                required: false,
                multiple: false,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'ec2c0ed364d64f8282f8fcf57bd5b25c',
              field: 'fams',
              label: '描述',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入描述',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '4f0ac0188df9467b945d95c078d2ceee',
              field: 'mc',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'c08556d77b654e1ea4c50523f0712e31',
              field: 'fasx',
              label: '方案时效',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2008724534063562753' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2008724534063562753',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'bbf448895c5f4da3afc28e1075477bce',
              field: 'jclx',
              label: '检查类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2008724308439367682' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2008724308439367682',
                style: { width: '100%' },
              },
            },
            {
              key: 'f14330d6bf5c4ea3b0d350b816f72f02',
              field: 'zjfs',
              label: '质检方式',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2001225699288457217' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001225699288457217',
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'end',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '1727533d08ef4b55badd7fc314b8f2c8',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '质检项目',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '1cde59eb325245e0973b9c516ed2b2c5',
              label: '',
              field: 'mesQuailtyInspectionProjectList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesQuailtyInspectionProjectList',
                columns: [
                  {
                    key: '7390529ac18845b78af23194d4b42a90',
                    title: 'ID',
                    dataIndex: 'inspectionId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'id',
                    },
                  },
                  {
                    key: '8128bb9481dc4c0da9ebda365fd99c11',
                    title: '名称',
                    dataIndex: 'mc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入名称',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'mc',
                    },
                  },
                  {
                    key: 'fb9ed7247bdc4573bd04dee229f7c9d4',
                    title: '编号',
                    dataIndex: 'bh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入编号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bh',
                    },
                  },
                  {
                    key: '3ec87967b62f4be5a002aa3e39ede7c6',
                    title: '项目类别',
                    dataIndex: 'xmlb',
                    componentType: 'AssociateSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: true,
                      disabled: true,
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/zlgl//zjjcsj/getQuailtyParent',
                        method: 'GET',
                        apiId: '411fc85b91c84ddcacdbd8a5cd0b9466',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          "var sql = 'select *,id as value,mc as label from mes_quality_type where delete_mark=0';\r\nreturn db.select(sql)",
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'xmlb',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '841b822bc69e43baae77be13cd9d6360',
                    title: '数据类型',
                    dataIndex: 'sjlx',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: null,
                      datasourceType: 'dic',
                      params: { itemId: '2008384790545207297' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      itemId: '2008384790545207297',
                      prestrainField: 'sjlx',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '10470f2a88a4487381aaa701c82d316d',
                    title: '标准值',
                    dataIndex: 'bzz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bzz',
                    },
                  },
                  {
                    key: 'abfb4099ff954673b65d3c943d6f7290',
                    title: '上限',
                    dataIndex: 'sx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'sx',
                    },
                  },
                  {
                    key: '361bc50a8c9941b0a2dfceee09c58253',
                    title: '下限',
                    dataIndex: 'xx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'xx',
                    },
                  },
                  {
                    key: '0ce8d110bebf44928fa2b7e654f4f049',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'bz',
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/zlgl//zjjcsj/getQuailtyParentList',
                  method: 'GET',
                  apiId: 'copy1767754302615d33226',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,mc as label from mes_quailty_project where delete_mark=0';\r\nreturn db.select(sql)",
                  outputParams: [
                    { name: 'bh', tableTitle: '编号' },
                    { name: 'mc', tableTitle: '名称' },
                    { name: 'bzz', tableTitle: '标准值' },
                    { name: 'sjlx', tableTitle: '数据类型' },
                    { name: 'sx', tableTitle: '上限' },
                    { tableTitle: '下限', name: 'xx' },
                    { name: 'xmlb', tableTitle: '项目类别' },
                    { name: 'id', tableTitle: 'ID' },
                  ],
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: true,
                buttonName: '增加',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: true,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: true,
                hasCheckedCol: true,
                events: {},
                showPagenation: true,
                showColunmSet: true,
                widths: [
                  {
                    key: '7390529ac18845b78af23194d4b42a90',
                    name: 'ID',
                    bindField: 'inspection_id',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '8128bb9481dc4c0da9ebda365fd99c11',
                    name: '名称',
                    bindField: 'mc',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: 'fb9ed7247bdc4573bd04dee229f7c9d4',
                    name: '编号',
                    bindField: 'bh',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '3ec87967b62f4be5a002aa3e39ede7c6',
                    name: '项目类别',
                    bindField: 'xmlb',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: false,
                  },
                  {
                    key: '841b822bc69e43baae77be13cd9d6360',
                    name: '数据类型',
                    bindField: 'sjlx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '10470f2a88a4487381aaa701c82d316d',
                    name: '标准值',
                    bindField: 'bzz',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: 'abfb4099ff954673b65d3c943d6f7290',
                    name: '上限',
                    bindField: 'sx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '361bc50a8c9941b0a2dfceee09c58253',
                    name: '下限',
                    bindField: 'xx',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: true,
                  },
                  {
                    key: '0ce8d110bebf44928fa2b7e654f4f049',
                    name: '备注',
                    bindField: 'bz',
                    width: null,
                    minWidth: null,
                    maxWidth: null,
                    resizable: false,
                    unit: null,
                    isEdit: false,
                  },
                ],
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
