import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'rwbh',
    label: '任务编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'sfnbdd',
    label: '是否内部订单',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 2, label: '是', value: '1' },
        { key: 3, label: '否', value: '2' },
      ],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'jhbh',
    title: '计划编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'rwbh',
    title: '任务编号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cpid',
    title: '生产产品',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'rch',
    title: '熔次号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'zch',
    title: '铸次号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'zl',
    title: '重量/KG',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jhksrq',
    title: '任务日期开始时间',
    componentType: 'date-range',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jhjsrq',
    title: '任务日期结束时间',
    componentType: 'date-range',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
      isClick: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
      isClick: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '3e3187de71654c0e9761cc59cbd16b80',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '8c8e1195fac049468aac7e5096b32835',
              field: 'rwbh',
              label: '任务编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请输入任务编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'SCRW',
                required: true,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'b22f0a133613428f84ee08c70c61311b',
              field: 'zch',
              label: '铸次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入铸次号',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'c1164302d0e34bca96563db3f47700f6',
              field: 'cpid',
              label: '生产产品',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择生产产品',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '选择产品',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                  outputParams: [
                    { name: 'cpmc', tableTitle: '产品名称', show: true, width: 150 },
                    {
                      name: 'cplx',
                      tableTitle: '产品类别',
                      bindField: 'cplx',
                      show: true,
                      width: 150,
                      component: 'a954da9a8da9429895b9ca947b937c92',
                    },
                    {
                      name: 'gg',
                      tableTitle: '规格',
                      bindField: 'gg',
                      show: true,
                      width: 150,
                      component: '6baebd752fae4267aa0ce0a684aa3a1c',
                    },
                  ],
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '25e30bcce47a437fb5674d9dbce3523a',
              field: 'zl',
              label: '重量/KG',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: null,
                step: 0.1,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '90df3bd996a3469789d4557edf80aca7',
              field: 'gylx',
              label: '工艺路线',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择工艺路线工艺路线工艺路线工艺路线',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllgylx',
                  method: 'GET',
                  apiId: '07d17a5272a746c5b8711e8820440c65',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,name as label from roke_routing where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: { change: "formActionType.refreshAPI('29977890304c441bae527eba5f019e46')" },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'd27a9e1461404e13bfa27c0e8b5b94a8',
              field: 'jhbh',
              label: '计划编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入计划编号计划编号',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'd3addcbd077740439873f39f77b4f57f',
              field: 'hjzt',
              label: '合金状态',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入合金状态',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a954da9a8da9429895b9ca947b937c92',
              field: 'cplx',
              label: '产品类别',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择产品类别',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: true,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2003761375221407745' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: '8970047af14d421897b19c5dbd0cb216',
              field: 'zxbz',
              label: '执行标准',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入执行标准',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '393152195470452c989d23033a75e13b',
              field: 'bom',
              label: 'BOM',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择BOMBOM',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/wlqd/getAllBomItemList',
                  method: 'GET',
                  apiId: '1a6a0c6bab2a4aceaf761b0c2c8d17a0',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,wlmc as label from mes_base_bom_item where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: { change: 'curRowData.mesProductionGongdanList={}' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'eb29665fc1e3453d9ef8aa88f8dfac0c',
              field: 'zzl',
              label: '铸造量',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入铸造量',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '4a0ed1a29c0348a1b84c6be48e9ef6dc',
              field: 'kh',
              label: '客户',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入客户',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '6baebd752fae4267aa0ce0a684aa3a1c',
              field: 'gg',
              label: '规格',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入规格',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'e35543642daf4df5b48c636ce8bb3f4c',
              field: 'jhksrq,jhjsrq',
              label: '任务日期',
              type: 'date-range',
              component: 'RangePicker',
              componentProps: {
                span: 7,
                defaultValue: [],
                width: '100%',
                showTime: false,
                format: 'YYYY-MM-DD',
                startTimePlaceholder: '请选择开始日期',
                endTimePlaceholder: '请选择结束日期',
                showLabel: true,
                disabled: false,
                allowClear: true,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
                placeholder: ['请选择开始日期', '请选择结束日期'],
              },
              colProps: { span: 24 },
            },
            {
              key: '21610208f2b8428e84de66979709d296',
              field: 'sccj',
              label: '车间',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择车间',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '2006262512610115585',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllChejian',
                  method: 'GET',
                  apiId: '59730efb7b4a4439a013cac04926e00e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select *,id as value,cjmc as label from mes_base_chejian where delete_mark=0'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '3c95be972e5b4ebfb6fc32a629199a07',
              field: 'rch',
              label: '熔次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入熔次号',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a5e642899c704810897d4d25a7604b4f',
              field: 'jz',
              label: '均质',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 2, label: '是', value: '1' },
                  { key: 3, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: '1',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: null,
                style: {},
              },
            },
            {
              key: 'fd52ee27396a4a028c80e1f6b883efaf',
              field: 'sl',
              label: '数量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: null,
                step: 0.1,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'd66e5ebfa5d64b829fde596c82155158',
              field: 'sfnbdd',
              label: '是否内部订单',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 2, label: '是', value: '1' },
                  { key: 3, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: '2',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: null,
                style: {},
              },
            },
            {
              key: '427fc55accd744d0a6359faf80e45a1b',
              field: 'sccx',
              label: '产线',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择产线',
                showLabel: true,
                showSearch: false,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getCxByCjbh',
                  method: 'GET',
                  apiId: 'ecbc0291292c49fca50468561b9770e8',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'cjid',
                          value:
                            '{"bindField":"sccj","fieldKey":"21610208f2b8428e84de66979709d296"}',
                          description: null,
                          required: true,
                          dataType: null,
                          type: null,
                          defaultValue: '0',
                          validateType: null,
                          error: null,
                          expression: null,
                          children: null,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select cx.*,cx.id as value,cx.cxmc as label from mes_base_chanxian cx join mes_base_cj_cx rela on cx.id=rela.cxid where rela.delete_mark=0 and cx.delete_mark=0 and rela.cjid=#{cjid}'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'be5dd9f33feb447c83f8313511feab47',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '工单',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '29977890304c441bae527eba5f019e46',
              label: '',
              field: 'mesProductionGongdanList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesProductionGongdanList',
                columns: [
                  {
                    key: '2745856f030c4f4b8488732136060d78',
                    title: '任务编号',
                    dataIndex: 'rwbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入任务编号任务编号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e2a2a9437363423b93f280617e27d8d2',
                    title: '计划编号',
                    dataIndex: 'jhbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入计划编号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '589c359e5a7e498695fcf5c224a5e557',
                    title: '熔次号',
                    dataIndex: 'rch',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入熔次号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '2957c762b0a3437f872fdab6f46544c2',
                    title: '铸次号',
                    dataIndex: 'zch',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入铸次号单行文本',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '7551731ee33d4289b153e8ddc7e4c8dc',
                    title: '合金状态',
                    dataIndex: 'hjzt',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入合金状态',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '69da890610284539b4ad26bed8e9c566',
                    title: '产品ID',
                    dataIndex: 'cpid',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入产品ID',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'dc242ae845f1489a8cc2f47c98b565b8',
                    title: '产品类型',
                    dataIndex: 'cplx',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '请选择下拉选择',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: null,
                      datasourceType: 'dic',
                      params: { itemId: '2003761375221407745' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      itemId: '2003761375221407745',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'f9b91195ee9840268e20bddeccdc365c',
                    title: '客户',
                    dataIndex: 'kh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入客户单行文本',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '2f069a67fe784742a2729fa09af94ec4',
                    title: '工序',
                    dataIndex: 'gx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入工序单行文本',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'pid',
                    },
                  },
                  {
                    key: '16fd1699db7744379edd01b6eb5653f9',
                    title: '工序名称',
                    dataIndex: 'gxmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入工序名称名称',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: 'pname',
                    },
                  },
                  {
                    key: 'b0a0abbf874c4059a646b9d454eaaae2',
                    title: 'zzl',
                    dataIndex: 'zzl',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入zzl',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '97877128b5014becb5cd6295ead760ff',
                    title: 'sl',
                    dataIndex: 'sl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 0.1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: false,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'db65c51ffaa7433896ecae60648cca9a',
                    title: 'zl',
                    dataIndex: 'zl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 0.1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: false,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'd1597b263c85496190e47c5e399f414f',
                    title: 'gg',
                    dataIndex: 'gg',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入gg',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'c1c1e89a76574351b454defc1fe8d1f6',
                    title: 'zxbz',
                    dataIndex: 'zxbz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入zxbz',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '99b87e4da6584d199204a47cd1a0243d',
                    title: 'sccj',
                    dataIndex: 'sccj',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入sccj',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '5f622be3883e4d1eafe68d9e82e5d25d',
                    title: 'sccx',
                    dataIndex: 'sccx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入sccx',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '12382799a03d462587e0f1552eaea581',
                    title: 'jsyq',
                    dataIndex: 'jsyq',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入jsyq',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'dee34a8120874c6e90992c42bdb9f021',
                    title: 'sfnbdd',
                    dataIndex: 'sfnbdd',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入sfnbdd',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '4947868d8b55470192988b50e680114f',
                    title: 'zt',
                    dataIndex: 'zt',
                    componentType: 'Input',
                    defaultValue: '1',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '1',
                      placeholder: '请输入zt',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {
                  path: '/scgl/scrw/getAllGxByGyId',
                  method: 'GET',
                  apiId: '47e4e4aaab1c495b89d3f04478fc86ab',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'rid',
                          value:
                            '{"bindField":"gylx","fieldKey":"90df3bd996a3469789d4557edf80aca7"}',
                          description: null,
                          required: false,
                          dataType: null,
                          type: null,
                          defaultValue: '0',
                          validateType: null,
                          error: null,
                          expression: null,
                          children: null,
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select r.id,r.name rname,p.id pid,p.name pname from roke_routing r join roke_routing_process rp on r.id=rp.routing_id join roke_process p on rp.process_id=p.id ?{rid,where r.id=#{rid}}';\r\nreturn db.select(sql)",
                },
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {
                  load: 'for(let i=0;i<formModel.mesProductionGongdanList.length;i++){ formModel.mesProductionGongdanList[i].rwbh=formModel.rwbh;\nformModel.mesProductionGongdanList[i].jhbh=formModel.jhbh;\nformModel.mesProductionGongdanList[i].rch=formModel.rch;\nformModel.mesProductionGongdanList[i].zch=formModel.zch;\nformModel.mesProductionGongdanList[i].hjzt=formModel.hjzt;\nformModel.mesProductionGongdanList[i].cpid=formModel.cpid;\nformModel.mesProductionGongdanList[i].cplx=formModel.cplx;\nformModel.mesProductionGongdanList[i].kh=formModel.kh;\nformModel.mesProductionGongdanList[i].zzl=formModel.zzl;\nformModel.mesProductionGongdanList[i].sl=formModel.sl;\nformModel.mesProductionGongdanList[i].zl=formModel.zl;\nformModel.mesProductionGongdanList[i].gg=formModel.gg;\nformModel.mesProductionGongdanList[i].zxbz=formModel.zxbz;\nformModel.mesProductionGongdanList[i].sccj=formModel.sccj;\nformModel.mesProductionGongdanList[i].sccx=formModel.sccx;\nformModel.mesProductionGongdanList[i].jsyq=formModel.jsyq;\nformModel.mesProductionGongdanList[i].sfnbdd=formModel.sfnbdd;\n}',
                },
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 24,
          name: '物料清单',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
