import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cpmc',
    label: '产品名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cpbh',
    label: '产品编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cplx',
    label: '产品类别',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2003761375221407745' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'xh',
    label: '型号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'hjzt',
    label: '合金状态',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'nbdm',
    label: '内部代码',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'sfyx',
    label: '有效的',
    defaultValue: 1,
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cpmc',
    title: '产品名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpbh',
    title: '产品编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cplx',
    title: '产品类别',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gg',
    title: '规格',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'xh',
    title: '型号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'hjzt',
    title: '合金状态',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'nbdm',
    title: '内部代码',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'erpid',
    title: 'ERP ID',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'sfyx',
    title: '有效的',
    componentType: 'switch',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '1f1fb7bd2e914b399e728160b594bc33',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 2,
          list: [
            {
              key: '4e15f120f3ee4d9fbe0a1a0ae9e2f97e',
              field: 'cptp',
              label: '',
              type: 'image',
              component: 'Image',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 2,
                defaultValue: '',
                showLabel: true,
                isShow: true,
                isUpload: true,
                sourceType: 'album,camera',
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 4,
          list: [
            {
              key: 'a460a8af25d04694a22bd64a032030e0',
              field: 'cpmc',
              label: '产品名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入产品名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dc527027d15944a9b6b09232f0cd4789',
              field: 'cpbh',
              label: '产品编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入产品编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        { span: 1, list: [] },
        {
          span: 8,
          list: [
            {
              key: '8b4babad12cb4d669d171a78abbd8175',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 4,
                  list: [
                    {
                      key: '229a158148af45808c1527cc7dc76677',
                      field: 'kxs',
                      label: '',
                      type: 'checkbox',
                      component: 'ApiCheckboxGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        staticOptions: [{ key: 1, label: '可销售', value: '1' }],
                        datasourceType: 'staticData',
                        defaultSelect: '1',
                        labelField: 'label',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        listStyle: "return 'margin-left:30px;'",
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 4,
                  list: [
                    {
                      key: '858413cbade048248b39abd7ee1b9641',
                      field: 'kcg',
                      label: '',
                      type: 'checkbox',
                      component: 'ApiCheckboxGroup',
                      colProps: { span: 24 },
                      componentProps: {
                        span: 7,
                        showLabel: true,
                        disabled: false,
                        staticOptions: [{ key: 1, label: '可采购', value: '1' }],
                        datasourceType: 'staticData',
                        defaultSelect: '1',
                        labelField: 'label',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        listStyle: "return 'margin-left:30px;'",
                        style: {},
                      },
                    },
                  ],
                },
                { span: 4, list: [] },
              ],
              componentProps: {
                gutter: 0,
                justify: 'start',
                align: 'bottom',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '0',
                margin: '0',
                span: 0,
              },
            },
            {
              key: '64df29de9dfa47bfba8cb389db383c2d',
              field: 'wllx',
              label: '',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 0,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 1, label: '半成品', value: '半成品' },
                  { key: 2, label: '成品', value: '成品' },
                  { key: 3, label: '原材料', value: '原材料' },
                  { key: 4, label: '其它', value: '其它' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: '',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        justify: 'start',
        align: 'bottom',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'aa875806550d4c22b12a5aa8e82495f1',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '基础信息',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '9973c1c91dd94ae3a1f5f1f97816ced5',
              field: '',
              label: '文本',
              type: 'text',
              component: 'Text',
              colProps: { span: 24 },
              defaultValue: '基础',
              componentProps: {
                defaultValue: '基础',
                color: '',
                align: 'left',
                fontSize: 16,
                fontWeight: 'bold',
                fontFamily: '黑体',
                fontStyle: 'normal',
                isShow: true,
                padding: '0',
                margin: '0',
                style: {},
              },
            },
            {
              key: '07a43f641ec5454487ace5f117bb98a0',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 6,
                  list: [
                    {
                      key: '61a60627cf7b44b5a3131074bebc5a64',
                      field: 'cplx',
                      label: '产品类别',
                      type: 'select',
                      component: 'XjrSelect',
                      colProps: { span: 24 },
                      componentProps: {
                        width: '100%',
                        span: 7,
                        placeholder: '请选择下拉选择产品类别',
                        showLabel: true,
                        showSearch: false,
                        isMultiple: false,
                        clearable: false,
                        disabled: false,
                        staticOptions: [
                          { key: 1, label: 'Option 1', value: 'Option 1' },
                          { key: 2, label: 'Option 2', value: 'Option 2' },
                          { key: 3, label: 'Option 3', value: 'Option 3' },
                        ],
                        datasourceType: 'dic',
                        labelField: 'name',
                        valueField: 'value',
                        apiConfig: {
                          path: 'CodeGeneration/selection',
                          method: 'GET',
                          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                        },
                        dicOptions: [],
                        required: false,
                        rules: [],
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        params: { itemId: '2003761375221407745' },
                        itemId: '2003761375221407745',
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: '844afd05cb5048449fb49670df62bfdb',
                      field: 'fpl',
                      label: '废品率（%）',
                      type: 'number',
                      component: 'InputNumber',
                      colProps: { span: 24 },
                      defaultValue: 0,
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: 0,
                        min: 0,
                        max: 100,
                        step: 0.1,
                        disabled: false,
                        showLabel: true,
                        controls: true,
                        required: false,
                        subTotal: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: 'adc48bfeb4ec40c982b4b6c40c07a8e1',
                      field: 'sfyx',
                      label: '有效的',
                      type: 'switch',
                      component: 'Switch',
                      colProps: { span: 24 },
                      defaultValue: 1,
                      componentProps: {
                        span: 7,
                        defaultValue: 1,
                        checkedChildren: '',
                        unCheckedChildren: '',
                        checkedColor: '#1C8DFF',
                        unCheckedColor: '#bbbdbf',
                        showLabel: true,
                        disabled: false,
                        events: {},
                        isShow: true,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: {},
                      },
                    },
                  ],
                },
                {
                  span: 6,
                  list: [
                    {
                      key: 'ddeda11a238e4e0b9b18006c0202b511',
                      field: 'gg',
                      label: '规格',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入规格',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: 'e0a69ab733de4819bc02c8305de3521e',
                      field: 'bzzl',
                      label: '标准重量',
                      type: 'number',
                      component: 'InputNumber',
                      colProps: { span: 24 },
                      defaultValue: 0,
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: 0,
                        min: 0,
                        step: 1,
                        disabled: false,
                        showLabel: true,
                        controls: true,
                        required: false,
                        subTotal: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 6,
                  list: [
                    {
                      key: '8f188c8662e54061b2943d5fb896bc8f',
                      field: 'xh',
                      label: '型号',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入型号',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: '19b87c1f6faf41588c18aa15647c2026',
                      field: 'hjzt',
                      label: '合金状态',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入合金状态',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                {
                  span: 6,
                  list: [
                    {
                      key: 'b3565aaf26f140b4943dd3a8fbb83e06',
                      field: 'nbdm',
                      label: '内部代码',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入内部代码',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: '9cd3ae5314614be5b1929c3503a54841',
                      field: 'erpid',
                      label: 'ERP ID',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入ERP ID',
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
              ],
              componentProps: {
                gutter: 0,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '0',
              },
            },
          ],
        },
        {
          span: 24,
          name: '作业规范',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '18b105f9641a4a03841e8397876a6a1e',
              field: 'zygf',
              label: '作业规范（文件）',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 2,
                defaultValue: '',
                accept: '',
                maxNumber: 10,
                maxSize: '',
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const treeConfig = {
  id: '1768452851557543938',
  isMultiple: false,
  name: 'api树',
  type: 2,
  configTip: '',
  config: [
    { bindFiled: '', name: 'label-0', value: 'a' },
    { bindFiled: '', name: '测试', value: 'b' },
    { bindFiled: '', name: '开发', value: 'c' },
  ],
};
