import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQbFinishReport分页参数 模型
 */
export interface MesQbFinishReportPageParams extends BasicPageParams {
  reportNo: string;

  reportName: string;

  checkDate: string;

  checkUser: string;

  errorState: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  createDateStart: string;
  createDateEnd: string;

  judgeResult: string;

  remark: string;
}

/**
 * @description: MesQbFinishReport分页返回值模型
 */
export interface MesQbFinishReportPageModel {
  id: string;

  reportNo: string;

  reportName: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  judgeResult: string;

  checkUser: string;

  checkDate: string;

  createDate: string;

  errorState: string;
}

/**
 * @description: MesQbFinishReport表类型
 */
export interface MesQbFinishReportModel {
  id: number;

  isSysNum: string;

  reportNo: string;

  reportName: string;

  checkUser: string;

  checkDate: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  checkreportNo: string;

  judgeResult: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQbFinishDetailList?: MesQbFinishDetailModel;
}

/**
 * @description: MesQbFinishDetail表类型
 */
export interface MesQbFinishDetailModel {
  id: number;

  reportId: number;

  reportNo: string;

  reportName: string;

  workNo: string;

  saleId: string;

  saleNo: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  carId: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  errorNum: string;

  errorMethod: string;

  imgFile: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQbFinishReport分页返回值结构
 */
export type MesQbFinishReportPageResult = BasicFetchResult<MesQbFinishReportPageModel>;
