
import { MesEquipmentFileInfoPageModel, MesEquipmentFileInfoPageParams, MesEquipmentFileInfoPageResult } from './model/SbglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/sbgl/page',
  List = '/jcsj/sbgl/list',
  Info = '/jcsj/sbgl/info',
  MesEquipmentFileInfo = '/jcsj/sbgl',
  
  
  
}

/**
 * @description: 查询MesEquipmentFileInfo分页列表
 */
export async function getMesEquipmentFileInfoPage(params: MesEquipmentFileInfoPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentFileInfoPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesEquipmentFileInfo信息
 */
export async function getMesEquipmentFileInfo(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentFileInfoPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesEquipmentFileInfo
 */
export async function addMesEquipmentFileInfo(mesEquipmentFileInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesEquipmentFileInfo,
      params: mesEquipmentFileInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesEquipmentFileInfo
 */
export async function updateMesEquipmentFileInfo(mesEquipmentFileInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesEquipmentFileInfo,
      params: mesEquipmentFileInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesEquipmentFileInfo（批量删除）
 */
export async function deleteMesEquipmentFileInfo(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesEquipmentFileInfo,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




