
import { MesAlloyStandardPageModel, MesAlloyStandardPageParams, MesAlloyStandardPageResult } from './model/HujinbzModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/hujinbz/page',
  List = '/jcsj/hujinbz/list',
  Info = '/jcsj/hujinbz/info',
  MesAlloyStandard = '/jcsj/hujinbz',
  
  
  
}

/**
 * @description: 查询MesAlloyStandard分页列表
 */
export async function getMesAlloyStandardPage(params: MesAlloyStandardPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesAlloyStandardPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesAlloyStandard信息
 */
export async function getMesAlloyStandard(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesAlloyStandardPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesAlloyStandard
 */
export async function addMesAlloyStandard(mesAlloyStandard: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesAlloyStandard,
      params: mesAlloyStandard,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesAlloyStandard
 */
export async function updateMesAlloyStandard(mesAlloyStandard: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesAlloyStandard,
      params: mesAlloyStandard,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesAlloyStandard（批量删除）
 */
export async function deleteMesAlloyStandard(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesAlloyStandard,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




