import { USER_STATE } from "@/common/enums/im.ts"
import http from '@/common/request/im.js';
import {
	defineStore
} from 'pinia';

export const useIMUserStore = defineStore('imUser', {
	state: () => {
		return {
			userInfo: {},
			state: USER_STATE.FREE
		}
	},
	actions: {
		setUserInfo(userInfo) {
			// 使用深拷贝方式，否则小程序页面不刷新
			Object.assign(this.userInfo, userInfo);
		},
		setUserState(userState) {
			this.state = userState;
		},
		clear(state) {
			this.userInfo = {};
			this.state = USER_STATE.FREE;
		},
		loadUser(state) {
			return new Promise((resolve, reject) => {
				http({ url: '/user/self', method: 'get' }).then((userInfo) => {
					this.setUserInfo(userInfo)
					resolve();
				}).catch((res) => {
					reject(res);
				});
			})
		}
	},
}) 