import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'index',
    label: '序号标识',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'pickingLogotype',
    label: '业务标识',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '采购入库单', value: '采购入库单' },
        { key: 2, label: '销售出库单', value: '销售出库单' },
        { key: 3, label: '生产领料单', value: '生产领料单' },
        { key: 4, label: '生产入库单', value: '生产入库单' },
        { key: 5, label: '其他入库单', value: '其他入库单' },
        { key: 6, label: '其他出库单', value: '其他出库单' },
        { key: 7, label: '库存调拨单', value: '库存调拨单' },
        { key: 8, label: '库存盘点单', value: '库存盘点单' },
        { key: 9, label: '委外领料单', value: '委外领料单' },
        { key: 10, label: '委外入库单', value: '委外入库单' },
      ],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'sequenceId',
    label: '序号规则',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'srcLocationId',
    label: '默认源位置',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/getLocationAll',
        method: 'GET',
        apiId: '69e28b1debda431f93b97e2d8adcc601',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_stock_location where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'destLocationId',
    label: '默认目的位置',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/getLocationAll',
        method: 'GET',
        apiId: '69e28b1debda431f93b97e2d8adcc601',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_stock_location where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'type',
    label: '移动类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '出库', value: '出库' },
        { key: 2, label: '入库', value: '入库' },
        { key: 3, label: '内部调拨', value: '内部调拨' },
      ],
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'returnType',
    label: '退回作业类型	',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/getZylxList',
        method: 'GET',
        apiId: '75d17bde76334769a2102222dd7b6a94',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          '\r\nvar sql="select id as value,name as label from roke_stock_picking_type where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'index',
    title: '序号标识',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'pickingLogotype',
    title: '业务标识',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '采购入库单', value: '采购入库单' },
        { key: 2, label: '销售出库单', value: '销售出库单' },
        { key: 3, label: '生产领料单', value: '生产领料单' },
        { key: 4, label: '生产入库单', value: '生产入库单' },
        { key: 5, label: '其他入库单', value: '其他入库单' },
        { key: 6, label: '其他出库单', value: '其他出库单' },
        { key: 7, label: '库存调拨单', value: '库存调拨单' },
        { key: 8, label: '库存盘点单', value: '库存盘点单' },
        { key: 9, label: '委外领料单', value: '委外领料单' },
        { key: 10, label: '委外入库单', value: '委外入库单' },
      ];

      return staticOptions.filter((x) => x.value == record.pickingLogotype)[0]?.label;
    },

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'sequenceId',
    title: '序号规则',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'srcLocationId',
    title: '默认源位置',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'destLocationId',
    title: '默认目的位置',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'isDefault',
    title: '默认调拨方式',
    componentType: 'switch',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '1884306810c14918936149fdc66077ac',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: 'fe610f88625f4064a107013880539c7e',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '83f2a9558b764679b6a18321155070a1',
              field: 'index',
              label: '序号标识',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入序号标识',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '73701987bc4a471eaf01ba7f3263f94b',
              field: 'pickingLogotype',
              label: '业务标识',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '采购入库单', value: '采购入库单' },
                  { key: 2, label: '销售出库单', value: '销售出库单' },
                  { key: 3, label: '生产领料单', value: '生产领料单' },
                  { key: 4, label: '生产入库单', value: '生产入库单' },
                  { key: 5, label: '其他入库单', value: '其他入库单' },
                  { key: 6, label: '其他出库单', value: '其他出库单' },
                  { key: 7, label: '库存调拨单', value: '库存调拨单' },
                  { key: 8, label: '库存盘点单', value: '库存盘点单' },
                  { key: 9, label: '委外领料单', value: '委外领料单' },
                  { key: 10, label: '委外入库单', value: '委外入库单' },
                ],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '7c9debad47ea4b7c9e35ceb1605f468d',
              field: 'sequenceId',
              label: '序号规则',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入序号规则',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '4a345664727d4253afdeefd2fdfa9c3a',
              field: '',
              label: '标题',
              type: 'title',
              component: 'Title',
              colProps: { span: 24 },
              defaultValue: '位置',
              componentProps: {
                defaultValue: '位置',
                color: '',
                align: 'left',
                fontSize: 20,
                isShow: true,
                span: 7,
                style: {},
              },
            },
            {
              key: '8473b2640c8b4588b3c959f7827bfe4b',
              field: 'srcLocationId',
              label: '默认源位置',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '仓库', value: '仓库' },
                  { key: 2, label: '车间库存', value: '车间库存' },
                  { key: 3, label: '业务伙伴位置', value: '业务伙伴位置' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/getLocationAll',
                  method: 'GET',
                  apiId: '69e28b1debda431f93b97e2d8adcc601',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_stock_location where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'eecab3885a774c2298ba2a7c13a93374',
              field: 'destLocationId',
              label: '默认目的位置',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '仓库', value: '仓库' },
                  { key: 2, label: '车间库存', value: '车间库存' },
                  { key: 3, label: '业务伙伴位置', value: '业务伙伴位置' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/getLocationAll',
                  method: 'GET',
                  apiId: '69e28b1debda431f93b97e2d8adcc601',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_stock_location where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '600e8520e9734e51b44b6fcd93353494',
              field: 'type',
              label: '移动类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '出库', value: '出库' },
                  { key: 2, label: '入库', value: '入库' },
                  { key: 3, label: '内部调拨', value: '内部调拨' },
                ],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '93b40fa2500a44deb54d3b08d9e73eda',
              field: 'isDefault',
              label: '默认调拨方式',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '53bdc587d1ff4710930c1ff6556ab806',
              field: 'returnType',
              label: '退回作业类型\t',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '销售出库', value: '销售出库' },
                  { key: 2, label: '生产领料出库', value: '生产领料出库' },
                  { key: 3, label: '其他出库', value: '其他出库' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/getZylxList',
                  method: 'GET',
                  apiId: '75d17bde76334769a2102222dd7b6a94',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    '\r\nvar sql="select id as value,name as label from roke_stock_picking_type where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '9696b9ad855a4d598977fc59d767797d',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        { span: 12, list: [] },
        { span: 12, list: [] },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
