import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrderwork分页参数 模型
 */
export interface MesProOrderworkPageParams extends BasicPageParams {
  workNo: string;

  state: string;

  priority: string;

  planNo: string;

  orderNo: string;

  materialNo: string;

  materialName: string;

  planNum: string;

  unity: string;

  carId: string;

  lineId: string;

  craftId: string;

  saleOrderNo: string;

  createUserId: string;
}

/**
 * @description: MesProOrderwork分页返回值模型
 */
export interface MesProOrderworkPageModel {
  id: string;

  workNo: string;

  state: string;

  priority: string;

  planStartDate: string;

  planEndDate: string;

  realStartDate: string;

  realEndDate: string;

  materialNo: string;

  materialName: string;

  planNum: string;

  unity: string;

  carId: string;

  lineId: string;

  craftId: string;

  orderNo: string;

  planNo: string;

  saleOrderNo: string;

  createUserId: string;

  createDate: string;

  remark: string;
}

/**
 * @description: MesProOrderwork表类型
 */
export interface MesProOrderworkModel {
  id: number;

  isSysNum: string;

  workNo: string;

  orderId: string;

  orderNo: string;

  planId: string;

  planNo: string;

  priority: string;

  planStartDate: string;

  planEndDate: string;

  realStartDate: string;

  realEndDate: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  planNum: string;

  unity: string;

  carId: string;

  lineId: string;

  craftId: string;

  saleOrderNo: string;

  sendType: string;

  groupId: string;

  groupNo: string;

  groupName: string;

  sendRemark: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrderwork分页返回值结构
 */
export type MesProOrderworkPageResult = BasicFetchResult<MesProOrderworkPageModel>;
