import {
  MesBaseWarehouseModel,
  MesBaseWarehousePageParams,
  MesBaseWarehousePageResult,
} from './model/BaseWarehouseModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/basewarehouse/page',
  List = '/mes/basewarehouse/list',
  Info = '/mes/basewarehouse/info',
  MesBaseWarehouse = '/mes/basewarehouse',

  Export = '/mes/basewarehouse/export',
}

/**
 * @description: 查询MesBaseWarehouse分页列表
 */
export async function getMesBaseWarehousePage(
  params: MesBaseWarehousePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesBaseWarehousePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseWarehouse信息
 */
export async function getMesBaseWarehouse(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseWarehouseModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseWarehouse
 */
export async function addMesBaseWarehouse(
  mesBaseWarehouse: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseWarehouse,
      params: mesBaseWarehouse,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseWarehouse
 */
export async function updateMesBaseWarehouse(
  mesBaseWarehouse: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseWarehouse,
      params: mesBaseWarehouse,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseWarehouse（批量删除）
 */
export async function deleteMesBaseWarehouse(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseWarehouse,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesBaseWarehouse
 */
export async function exportMesBaseWarehouse(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
