import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';
export const searchFormSchema: FormSchema[] = [
  {
    field: 'reportNo',
    label: '巡检报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportName',
    label: '报告抬头',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'checkDate',
    label: '检验日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'carId',
    label: '车间',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                dataType: 'String',
                bindType: 'value',
                required: false,
                name: 'factory_type',
                value: '1',
              },
              { dataType: 'String', bindType: '', required: false, name: 'factory_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'car_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/mesFactory',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'stationId',
    label: '班组',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(group_name) AS label FROM mes_pro_group where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getMesGoupList',
        apiId: '',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkUser',
    label: '巡检员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686656230883135490' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'reportNo',
    title: '巡检报告编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'checkDate',
    title: '检验日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '报告抬头',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'carId',
    title: '车间',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'lineId',
    title: '产线',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'stationId',
    title: '班组',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'checkUser',
    title: '巡检员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '报告生成日期',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'c6a4b79c05bc4e488a6605ec02a2ed20',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        color: '',
        defaultValue: '基础信息',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9b416ca82c774e40bfbc78426c0df44f',
      field: 'reportNo',
      label: '巡检报告编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入巡检报告编号',
        addonBefore: '',
        autoCodeRule: 'mesxjbgNo',
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='reportNo';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        style: {},
      },
    },
    {
      key: '1decf8cad9d244898045f1e143b540e4',
      field: 'checkDate',
      label: '检验日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择检验日期',
        allowClear: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '5e872d8d13a84b7c965275e705233133',
      field: 'reportName',
      label: '报告抬头',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入报告抬头',
        allowClear: false,
        addonBefore: '',
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '2b6cb835da4d48be980c34a1d0f11617',
      field: 'carId',
      label: '车间',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  dataType: 'String',
                  bindType: 'value',
                  required: false,
                  name: 'factory_type',
                  value: '1',
                },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'factory_id',
                  value: '',
                },
                { dataType: 'String', bindType: '', required: false, name: 'car_id', value: '' },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/mesFactory',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
        },
        disabled: false,
        placeholder: '请选择车间',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: { change: "formActionType.refreshAPI('lineId')\nformModel.lineId='';" },
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd7b6e31e0bfd4caf9e5df206be6962e6',
      field: 'lineId',
      label: '产线',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  dataType: 'String',
                  bindType: 'value',
                  required: false,
                  name: 'factory_type',
                  value: '2',
                },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'factory_id',
                  value: '',
                },
                {
                  dataType: 'String',
                  bindType: 'data',
                  required: false,
                  name: 'car_id',
                  value: 'car_id',
                },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/mesFactory',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
        },
        disabled: false,
        placeholder: '请选择产线',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '79f96a4262794a1697141ed926df2ddb',
      field: 'stationId',
      label: '班组',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(group_name) AS label FROM mes_pro_group where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getMesGoupList',
          apiId: 'copy1691390939309d93946',
        },
        disabled: false,
        placeholder: '请选择班组',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '28109e0df79d4a0aa6c66f909a78bd94',
      field: 'checkUser',
      label: '巡检员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请选择巡检员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e3034eec7fec40f48967f8459b45fb02',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        style: { width: '100%' },
      },
    },
    {
      key: 'be92f7030f214b66aea1e7616dd52790',
      field: 'createDate',
      label: '报告生成日期',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        style: { width: '100%' },
      },
    },
    {
      key: 'b045c54b56fd4aa1910a6e241c6e48ff',
      field: 'state',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        valueField: 'value',
        params: { itemId: '1686656230883135490' },
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1686656230883135490',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: '0', value: '待发起', key: 1 },
          { label: '1', value: '审核中', key: 2 },
          { label: '2', value: '审核完成', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '6670d4f80efb4c37ac4b76bccea3fb5b',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测数据',
      componentProps: {
        color: '',
        defaultValue: '检测数据',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'f5bab6a61448429aa7316e167f7ab490',
      label: '',
      field: 'mesQpProcessPatroldataList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQpProcessPatroldataList',
        columns: [
          {
            key: '1f1a609e32d242298a59c0036f1547bd',
            title: '首件报告编号',
            dataIndex: 'firstId',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: true,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.report_no AS label,t.* FROM mes_qp_process_first t where 1=1 "+condition)',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'code',
                        dataType: 'String',
                        bindType: 'value',
                        description: '回显字段',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                      {
                        dataType: 'String',
                        bindType: '',
                        description: '查询类型',
                        required: false,
                        name: 'queryType',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getProcessFirstList',
                outputParams: [
                  {
                    show: true,
                    bindField: 'saleNo',
                    name: 'sale_no',
                    width: 150,
                    tableTitle: '销售单号',
                    component: '231f3ca6216c43958fd2652bbcbc4cf6',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: true,
                    bindField: 'productCode',
                    name: 'product_code',
                    width: 150,
                    tableTitle: '产品编码',
                    component: '27c472ffaedf46008f3f7514fba7f184',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: true,
                    bindField: 'productName',
                    name: 'product_name',
                    width: 150,
                    tableTitle: '产品名称',
                    component: '02f13f4afdb2438c81227766a7691ab0',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: true,
                    bindField: 'materialNo',
                    name: 'material_no',
                    width: 150,
                    tableTitle: '物料编码',
                    component: '10aac9998dba4af7b37c5dae4281106c',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: true,
                    bindField: 'materialName',
                    name: 'material_name',
                    width: 150,
                    tableTitle: '物料名称',
                    component: '1afda6e9a56e44bbbe43db45aacfb0dc',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: true,
                    bindField: 'firstNo',
                    name: 'report_no',
                    width: 150,
                    tableTitle: '首件报告编码',
                    component: '54b13f97de424e0ea9d654966a605934',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: false,
                    bindField: 'saleId',
                    name: 'sale_id',
                    width: 150,
                    tableTitle: '销售单号ID',
                    component: 'ca31619d6dd5423dbd6e631c1132fb1f',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: false,
                    bindField: 'productId',
                    name: 'product_id',
                    width: 150,
                    tableTitle: '产品ID',
                    component: 'a3e88b554b104f4a9f71ad1771964014',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                  {
                    show: false,
                    bindField: 'materialId',
                    name: 'material_id',
                    width: 150,
                    tableTitle: '物料ID',
                    component: '2812a67a61bf4438901b3831460ac958',
                    bindTable: 'mes_qp_process_patroldata',
                  },
                ],
                apiId: 'copy1691391564146d66156',
              },
              disabled: false,
              placeholder: '请选择首件报告编号',
              events: {},
              span: '',
            },
          },
          {
            key: '54b13f97de424e0ea9d654966a605934',
            title: '首件报告编号2',
            dataIndex: 'firstNo',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '2请输入',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'ca31619d6dd5423dbd6e631c1132fb1f',
            title: '销售单号ID',
            dataIndex: 'saleId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入销售单号ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '231f3ca6216c43958fd2652bbcbc4cf6',
            title: '销售单号',
            dataIndex: 'saleNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入销售单号',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'a3e88b554b104f4a9f71ad1771964014',
            title: '产品ID',
            dataIndex: 'productId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入产品ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '27c472ffaedf46008f3f7514fba7f184',
            title: '产品编码',
            dataIndex: 'productCode',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入产品编码',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '02f13f4afdb2438c81227766a7691ab0',
            title: '产品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入产品名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '2812a67a61bf4438901b3831460ac958',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              isShow: false,
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入物料ID',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '10aac9998dba4af7b37c5dae4281106c',
            title: '物料编码',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入物料编码',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '1afda6e9a56e44bbbe43db45aacfb0dc',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '请输入物料名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '19a3de1065ec4d1385c8d8cea2445407',
            title: '巡检时间',
            dataIndex: 'checkTime',
            componentType: 'TimePicker',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              format: 'HH:mm:ss',
              rules: [],
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请选择巡检时间',
              allowClear: true,
              events: {},
              span: '',
            },
          },
          {
            key: '19e603ed42064081a3550603b83297b8',
            title: '检测数量',
            dataIndex: 'checkNum',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '1f0a3d0d58564a69b3decebd7950b7b1',
            title: '单位',
            dataIndex: 'checkUnit',
            componentType: 'XjrSelect',
            componentProps: {
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.report_no AS label,t.* FROM mes_qp_process_first t where 1=1 "+condition)',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'code',
                        dataType: 'String',
                        bindType: 'value',
                        description: '回显字段',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                      {
                        dataType: 'String',
                        bindType: '',
                        description: '查询类型',
                        required: false,
                        name: 'queryType',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getUnlityList',
                apiId: 'copy1691393740624d1194',
              },
              disabled: false,
              placeholder: '',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '0b1958e661844d348168ea77ca1d3fce',
            title: '检测类别',
            dataIndex: 'checkType',
            componentType: 'XjrSelect',
            componentProps: {
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checktype where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckType',
                apiId: '7142de95ccfe43cb8beffe37a62474d2',
              },
              disabled: false,
              placeholder: '',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: 'd042872304d84f42b78069e8f2e321b1',
            title: '检测项目',
            dataIndex: 'checkProduct',
            componentType: 'XjrSelect',
            componentProps: {
              clearable: false,
              defaultSelect: '',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              showSearch: false,
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
                apiParams: [
                  { tableInfo: [], title: 'Query Params', key: '1' },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getCheckProduct',
                apiId: '662ac83978054327a0947126993b1175',
              },
              disabled: false,
              placeholder: '',
              staticOptions: [
                { label: 'Option 1', value: 'Option 1', key: 1 },
                { label: 'Option 2', value: 'Option 2', key: 2 },
                { label: 'Option 3', value: 'Option 3', key: 3 },
              ],
              events: {},
              span: '',
            },
          },
          {
            key: '6c336992cc314fa29e64c28f2e425c4a',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'eda5c14e2e6244bcad630bb75aa57543',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'e6030a3f079f49e6bbf7b6d736a90ed4',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'db9ab1a4ea424bd8b12e880c9d7a0493',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '72091ab8708f497da5b9baa32ead8088',
            title: '不良数',
            dataIndex: 'errorNum',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'b33dcdb58f904470ab0a4f11d34211d5',
            title: '不良处理方式',
            dataIndex: 'errorMethod',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择数据',
        showIndex: false,
        useSelectButton: false,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {},
        showFormBorder: true,
        span: '24',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
