import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '库区分类代码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '库区分类名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '分类状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '库区分类编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '库区分类名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { offset: 0, span: 4 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '4d7bedab882a49168f453e2bf41a2301',
      field: 'code',
      label: '仓库分类编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '3ad6c0f5e36a4666829be76106b5ef61',
      field: 'name',
      label: '仓库分类名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '7bdb8f5f1c514dbaa47bc3c053463328',
      field: 'sort',
      label: '分类排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '74a9a78fb022430fa89d1fb91ef63cbf',
      field: 'state',
      label: '分类状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'b3a821dab5524324b0ae06299d33c1f1',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '5a928f9feac04aafa6612748b0d8edd0',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 0,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '6af13840401744d0ac2d646a9d840b0d',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 2,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
