import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrderDetail分页参数 模型
 */
export interface MesProOrderDetailPageParams extends BasicPageParams {
  orderNo: string;

  saleOrderId: string;

  productName: string;

  onlineDate: string;

  priority: string;

  planNum: string;

  state: string;

  realNum: string;

  remark: string;

  speModel: string;

  unity: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesProOrderDetail分页返回值模型
 */
export interface MesProOrderDetailPageModel {
  id: string;

  orderNo: string;

  saleOrderId: string;

  productId: string;

  productName: string;

  onlineDate: string;

  priority: string;

  planNum: string;

  state: string;

  realNum: string;

  remark: string;

  speModel: string;

  unity: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProOrderDetail表类型
 */
export interface MesProOrderDetailModel {
  id: number;

  orderId: number;

  orderNo: string;

  orderName: string;

  orderUnit: string;

  priority: string;

  saleOrderId: string;

  saleOrderNo: string;

  productId: string;

  productNo: string;

  productName: string;

  speModel: string;

  unity: string;

  planNum: string;

  onlineDate: string;

  realNum: string;

  remark: string;

  cancelRemark: string;

  inStoreState: number;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrderDetail分页返回值结构
 */
export type MesProOrderDetailPageResult = BasicFetchResult<MesProOrderDetailPageModel>;